 
#include "mbed.h"
#include "Serial_HL.h"
#include "Bertl14.h"
#include "BertlObjects.h"

SerialBLK pc(USBTX, USBRX);
SvProtocol ua0(&pc);

//              main=2^0  LS    ENC 2^2
BusOut boardPow(p30,      P1_6, P1_7);

// ls5 nur beim Betrl15
// AnalogInHL ls1(p18), ls2(p16), ls3(p19), ls4(p17); // B14

AnalogInHL ls1(p18), ls2(p16), ls3(p20), ls4(p19), ls5(p17); // B15


void rightCurve()
{
  mL.SetPow(0.3); //rechts
  mR.SetPow(0.0);  
}

void leftCurve()
{
    mL.SetPow(0.0);   //links
    mR.SetPow(0.3);
}

void straight()
{
    mL.SetPow(0.3); //gerade
    mR.SetPow(0.3);
}

void stop()
{
    mL.SetPow(0.0);
    mR.SetPow(0.0);
    wait_ms(1000);
}

const int LS_THRSH = 400;

void LineFollow()
{
    while(1){
    if (ls1.Read() > LS_THRSH || ls2.Read() > LS_THRSH )
        {
          leftCurve();
        }
            
         else if(ls4.Read() > LS_THRSH || ls5.Read() > LS_THRSH )
        {
          rightCurve();
        }    
        else if (ls3.Read() > LS_THRSH)
        {
           straight(); 
        }
        else if (ls1.Read() < LS_THRSH || ls2.Read() < LS_THRSH || ls3.Read() < LS_THRSH || ls4.Read() < LS_THRSH || ls5.Read() < LS_THRSH)
        {
         stop();
         return;   
        }
        else
         straight();
    }
}

 
void TurnUntilLine()
{
    mL.SetPow2(-0.3);
    mR.SetPow2(0.3);
    
    while(1){
    
    if (ls3.Read()>400){
        mL.SetPow2(0.0);
        mR.SetPow2(0.0);
        return;
        }
    }
}

int main(void)
{
    pc.format(8,SerialBLK::None,1);
    pc.baud(115200); // 115200
    boardPow = 3;
        
    while(1) {
        LineFollow();
        wait_ms(1000);
        TurnUntilLine();
        wait_ms(1000);
    }
}
