/* Modulname:   SCHÖNI VICI CALC 4STATES      Version: 1.0   */
/* Funktion:    State-Machine-Programm                 */
/* Erstellt von: SC am: 2013-02-11                     */

#include "mbed.h"
#include "C12832_lcd.h"

bool newEvent =false; 
uint8_t event=0, state=0;

InterruptIn iiJsUp(p15);        //alle Funktionen von Joystick initialisieren
DigitalIn diJsUp(p15);
InterruptIn iiJsDown(p12);
DigitalIn diJsDown(p12);
InterruptIn iiJsCenter(p14);
DigitalIn diJsCenter(p14);
InterruptIn iiJsLeft(p13);
DigitalIn diJsLeft(p13);
InterruptIn iiJsRight(p16);
DigitalIn diJsRight(p16);
char calcOp = '+';              // calcOp festgelegt als "+" oder "-"
bool updateLcd = true;          // aktualisierung von LCD
int value1, value2, result;     // variablen fürs Rechnen festlegen, initialisierung
C12832_LCD lcd;

BusOut myLeds(LED1, LED2, LED3, LED4);  //Ledbar

// prototypes                   //festgelegte Funktionen werden hier abgearbeitet
void noFunction();              //keine Funktion
void selectAddition();          //Auswahl +
void selectSubtraction();       //Auswahl -
void CountTerm_1_Up();          //Erste Zahl wird raufgezählt
void CountTerm_2_Up();          //Zweite Zahl wird raufgezählt
void CountTerm_1_Down();        //Erste Zahl wird runtergezählt
void CountTerm_2_Down();        //Zweite Zahl wird runtergezählt
void reset();                   //rückgesetzt
void calculateResult();         //Ergebnis von Zahl1 und Zahl2

/****************************************************/
/* Tabelle fuer die naechsten Zustaende bei Eingabe */
/****************************************************/
uint8_t nextstate_tab[5][4]=
// current event/  present state 0  1  2  3
//----------------------
/* Event 0 (Joystick UP)    */{{ 1, 1, 1, 3 },  // next
/* Event 1 (Joystick DOWN)  */ { 1, 1, 1 ,3 },
/* Event 2 (Joystick LEFT)  */ { 0, 2, 2 ,0 },
/* Event 3 (Joystick RIGHT) */ { 0, 2, 2 ,0 },
/* Event 4 (Joystick CENTER)*/ { 0, 3, 3 ,3}}; // state
// state=nextstate_tab[event][state];        // gehe auf naechsten Zustand

/*************************************************************/
/* Tabelle fuer Aktionsroutinen fuer die Zustaende bei Input */ 
/*************************************************************/
//                           p r e s e n t    s t a t e  
void (*action[5][4])()= //      0        1               2           3    
/* event 0 */       {{ noFunction,selectAddition,selectAddition, noFunction},        
/* event 1 */        { noFunction,selectSubtraction,selectSubtraction,noFunction},
/* event 2 */        { CountTerm_1_Up,noFunction,CountTerm_2_Up,reset},
/* event 3 */        { CountTerm_1_Down,noFunction,CountTerm_2_Down,reset},
/* event 4 */        { noFunction,calculateResult,calculateResult,noFunction}};

// action routines              //Funktionen erstellen,was darin passiert
void noFunction() {
}

void selectAddition() {         
        calcOp = '+';
        lcd.locate(0, 20);
        lcd.printf("%d %c              ", value1, calcOp);  
}
void selectSubtraction() {      
        calcOp = '-';
        lcd.locate(0, 20);
        lcd.printf("%d %c              ", value1, calcOp);  
}
void CountTerm_1_Up() {
        value1++;
        lcd.locate(0, 20);
        lcd.printf("%d                ", value1);
}
void CountTerm_1_Down() {
        value1--;
        lcd.locate(0, 20);
        lcd.printf("%d                ", value1);
}
void CountTerm_2_Up() {
        value2++;
        lcd.locate(0, 20);
        lcd.printf("%d %c %d                ", value1, calcOp, value2);
}
void CountTerm_2_Down() {
        value2--;
        lcd.locate(0, 20);
        lcd.printf("%d %c %d                ", value1, calcOp, value2); 
}
void reset() {
        value1 = value2 = 0;
        lcd.locate(0, 20);
        lcd.printf("%d                ", value1);   
}
void calculateResult() {
    if (calcOp == '+')
        result = value1 + value2;
    else
        result = value1 - value2;       
        lcd.locate(0, 20);
        lcd.printf("%d %c %d = %d         ", value1, calcOp, value2, result);   
}

// common functions
uint8_t debounce(DigitalIn myIn)  
{
    #define LEVEL_CHECKS 16
    #define MAX_LOOPS 80                // stoppt das Überprüfen des Prellen nach max. MAX_LOOPS Durchläufen
    unsigned char port_buffer;
    unsigned char debounceCounter = 0;
    uint8_t loopCounter = 0;
    
    do
    {
        port_buffer = myIn;
        wait_us(100);
        loopCounter++;
        if(myIn == port_buffer)
          debounceCounter++;    // mindestens 'LEVEL_CHECKS' Abtastungen in Folge: gleicher Pegel
        else
          debounceCounter = 0;      
    }
    while ((debounceCounter <= LEVEL_CHECKS) && (loopCounter <= MAX_LOOPS));
    return loopCounter;
}

// ISR
void opPlus() { // op +: JsUp=event0
    debounce(diJsUp);
        event=0;
        newEvent = true;
}
void opMinus() { // op -: JsDown=event1
    debounce(diJsDown);
        event=1;
        newEvent = true;
}
void cntUp() { // value +1: JsLeft=event2
    debounce(diJsLeft);
        event=2;
        newEvent = true;
}
void cntDown() { // value -1: JsRight=event3
    debounce(diJsRight);
        event=3;
        newEvent = true;
}
void doCalc() { // calculate: JsCenter=event4
    debounce(diJsCenter);
        event=4;
        newEvent = true;    
}


void init() {               //hier wird alles initialisiert
    myLeds = 0;
    newEvent = false;
    state=0; 
    event=0;
    lcd.cls();
    lcd.locate(0,0);
    iiJsUp.rise(&opPlus);
    iiJsDown.rise(&opMinus);
    iiJsLeft.rise(&cntUp);
    iiJsRight.rise(&cntDown);
    iiJsCenter.rise(&doCalc);
}

int main()          //Hauptprogramm 
{
    init();
    lcd.printf("BULME Calculator BV");
    lcd.locate(0,10);
    lcd.printf("Berechung eingeben");   

    while(1) {
        if (newEvent) {
            newEvent=false;
            (*action[event][state])();                      // line 1 for executing sm: run action routine
            state = nextstate_tab[event][state];    // line 2 for executing sm: run state transition 
        }
    }
        return 1;
}
