
#include "mbed.h"
#include "Serial_HL.h"
#include "Bertl14.h"
#include "BertlObjects.h"

//              main=2^0  LS    ENC 2^2
BusOut boardPow(p30,      P1_6, P1_7);
Timer t2, t3;
//---------------------------------------------------------------



void LeftCurve()
{
    t3.reset();
    mL.SetPow2(0.2);
    mR.SetPow2(0.4);
    while (1) {
        if(t3.read_ms()>5000)
            break;
        if(t2.read_ms()>100)
         {
             t2.reset();
             pex.ToggleLeds(LED_FL1);
             }
    }
    mL.SetPow2(0.0);
    mR.SetPow2(0.0);
    pex.ClearLeds();
}

//---------------------------------------------------------------

void RightCurve()
{
    t3.reset();
    mL.SetPow2(0.4);
    mR.SetPow2(0.2);
    while (1) {
        if(t3.read_ms()>5000)
            break;
        if(t2.read_ms()>100)
         {
             t2.reset();
             pex.ToggleLeds(LED_FR1);
             }
    }
    mL.SetPow2(0.0);
    mR.SetPow2(0.0);
    pex.ClearLeds();
}


//---------------------------------------------------------------
void Forward()
{
    t3.reset();
    mL.SetPow2(0.2);
    mR.SetPow2(0.2);
    while (1) {
        if(t3.read_ms()>5000)
            break;
        if(t2.read_ms()>100)
         {
             t2.reset();
             pex.ToggleLeds(LED_ALL_FRONT);
             }
    }
    mL.SetPow2(0.0);
    mR.SetPow2(0.0);
    pex.ClearLeds();
}

//---------------------------------------------------------------
//---------------------------------------------------------------


int main(void)
{
    boardPow=1;
    wait_ms(10);
    InitBertl();
    pex.useISR=0;
    leds=9;
    pex.ClearLeds();


    pex.WaitUntilButtonPressed();
    
    t2.start();
    t3.start();

    while(1) {
        pex.ReadButtons();
        if( pex.IsButton (BTN_FLL|BTN_FL) )
            LeftCurve();
        if( pex.IsButton(BTN_FRR|BTN_FR))
            RightCurve();
        if( pex.IsButton(BTN_FM))
            Forward();
    }
    return 1;
}




