#include "mbed.h"
#include "BtnEventM0.h"

//Ledbar
BusOut  lb1(P1_7, P1_6, P1_4, P1_3, P1_1, P1_0, LED4, LED3, LED2, LED1);

// Statusled zeigt uns in welchem Zustand ide Statmachine gerade ist
BusOut stLED(P1_13, P1_12);

//erledigt für uns die Abfrage der positiven Flange
BtnEventM0 sw4(P1_16), sw3(P0_23);          //sw4 vorwärts  sw3 rückwärts

Serial pc(USBTX, USBRX);

const int St_Rot = 1;
const int St_Gelb = 1;
const int St_Gruen = 1;


class Ampel
{
public:
    void Init() {
        state=St_Rot;
        t1.start();
        t2.start();
        t3.start();
    }
    void Rot();
    void Gelb();
    void Gruen();
public:
    void RotAction();
    void GelbAction();
    void GruenAction();
public:
    int state;
    Timer t1;   //blinken
    Timer t2;   //mit 10 Hz zur anzeige schicken
    Timer t3;   //Zeit bis zum umschalten anzeigen

};

Ampel amp;


int main(void)
{
    amp.Init();
    sw3.Init();
    sw4.Init();
    pc.baud(125000);


    while(1) {

    }
}

//-----------------------------------------------------------------------------------------------------

void Ampel::Rot()
{
    //einmalige aktion
    pc.printf("ROT\n");
    t3.reset();
    while(1) {
        //Btn und Zeit abfragen (möglicher Zustandwechsel)
        if(t3.read_ms()>3000) {
            state=St_Gelb;
            return;
        }
        RotAction();
    }

}

void Ampel::RotAction()
{
    //Blinken
    if(t1.read_ms()>500) {
        t1.reset();
        if(lb1==0)
            lb1=1;       //bei Gelb soll dann lb=4
        else
            lb1 =0;
    }
    //RestZeit mit 10 Hz zur Anzeige senden
    if(t2.read_ms()>100) {
        t2.reset();
        pc.printf("2 %d\n", t3.read_ms()/100);   //Zeitanzeige auf 1/10sec genau
    }
}

