// Calculator: Addition and Subtraction
// Joystick Up: +  ; Joystick Down - (Operator selection)
// Joystick Left: count value up (+1); Joystick Right: count value down (-1)
// Joystick Center: Calculate
// Joystick Left or Joystick Right: start at input of value 1 again

#include "mbed.h"
#include "C12832_lcd.h"

InterruptIn iiUp(p15);//
DigitalIn diUp(p15);
InterruptIn iiDown(p12);//
DigitalIn diDown(p12);
InterruptIn iiCenter(p14);//
DigitalIn diCenter(p14);
InterruptIn iiLeft(p13);//
DigitalIn diLeft(p13);
InterruptIn iiRight(p16);//
DigitalIn diRight(p16);
uint8_t step = 0;
char calcOp = '+';
bool updateLcd = true;
int value1=0;int value2=0;int result;

// prototypes

// functions
uint8_t debounce(DigitalIn myIn)  
{
    #define LEVEL_CHECKS 8
    #define MAX_LOOPS 30                // stoppt das Überprüfen des Prellen nach max. MAX_LOOPS Durchläufen
    unsigned char port_buffer;
    unsigned char debounceCounter = 0;
    uint8_t loopCounter = 0;
    
    do
    {
        port_buffer = myIn;
        wait_us(100);
        loopCounter++;
        if(myIn == port_buffer)
          debounceCounter++;    // mindestens 'LEVEL_CHECKS' Abtastungen in Folge: gleicher Pegel
        else
          debounceCounter = 0;      
    }
    while ((debounceCounter <= LEVEL_CHECKS) && (loopCounter <= MAX_LOOPS));
    return loopCounter;
}

// ISR
void butnUp() {
    debounce(diUp);
    calcOp='+';    
    updateLcd=true;
    step=1;
}
void butnDown() {
    debounce(diDown);
    calcOp='-';
	updateLcd=true;
    step=1;
}
void butnLeft() {
    debounce(diLeft);
    if(step==0)
    {
    	value1++;
    	updateLcd=true;
    }
    if(step==1)
    {
    	value2++;
    	updateLcd=true;
    }
}
void butnRight() {
    debounce(diLeft);
    if(step==0)
    {
    	value1--;
    	updateLcd=true;
    }
    if(step==1)
    {
    	value2--;
    	updateLcd=true;
    }
}
void butnCenter() {
    debounce(diCenter);
    result=value1+value2;
    updateLcd=true;
    step=2;
}

// main program
int main() {
    C12832_LCD lcd;
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("4CHEL: Calulator");

	iiUp.rise(&butnUp);
	iiDown.rise(&butnDown);
	iiCenter.rise(&butnCenter);
	iiLeft.rise(&butnLeft);
	iiRight.rise(&butnRight);
	   
    while(1) { 
        if (updateLcd) {
            updateLcd = false;
            switch (step) {
                case 0:
                
    				lcd.cls();
    				
    				lcd.locate(0,0);
    				lcd.printf("4CHEL: Calulator");
    				
    				lcd.locate(0,10);
    				lcd.printf("Erste Zahl eingeben");
    				
                    lcd.locate(0, 20);
                    lcd.printf("%d", value1);
                    break;
				case 1:
					lcd.cls();
					
    				lcd.locate(0,0);
    				lcd.printf("4CHEL: Calulator");
    				
    				lcd.locate(0,10);
    				lcd.printf("Zweite Zahl eingeben");
    				
					lcd.locate(0, 20);
                    lcd.printf("%d %c %d", value1,calcOp,value2);
					break;
				case 2:
					lcd.cls();
					
    				lcd.locate(0,0);
    				lcd.printf("4CHEL: Calulator");
    				
    				lcd.locate(0,10);
    				lcd.printf("Ergebnis");
    				
					lcd.locate(0, 20);
                    lcd.printf("%d %c %d = %d", value1,calcOp,value2,result);
                    value1=0;value2=0;calcOp='+';
                    step=0;
					break;

                default: break;
            }
        }
    }
}

