#include "mbed.h"

#define MAX_UINT8 255

// class for a counter (counting up (+1,+2..), down (-1,-2..), setValue, getValue..) http://www.cplusplus.com/doc/tutorial/classes/
class clCount {
    uint8_t count, maxCount;
    int8_t direction,dirNew;
    #define UP 1
    #define DOWN -1
    
  public:
    clCount(void);              // constructor 1
    clCount(uint8_t, uint8_t);  // constructor 2 (overloaded)
    void countUp(void);
    void countDown(void);
    void countUp(uint8_t);
    void countDown(uint8_t);
    uint8_t getValue() {
        return count;
    }
    void setValue(uint8_t);
    void doCount(int8_t,uint8_t);
    void doCount(uint8_t);
    void changeDir(int8_t dirNew){direction = dirNew;}
};
// mit dem scope-Operator Member-Functions ausserhalb der Klassendefinition definieren
clCount::clCount(void) {    // "::" .. is the scope operator!
    count = 0;  
    maxCount = MAX_UINT8;  
}
clCount::clCount(uint8_t start, uint8_t max) {
    count = start;  
    maxCount = max;  
}
void clCount::countUp(void) {
    if (count < maxCount)
        count++;
    else
        count = 0;
}

void clCount::countUp(uint8_t ink) {
    if (count < maxCount)
        count=count+ink;
    else
        count = 0;
}

void clCount::countDown(void) {
    if (count > 0)
        count--;
    else
        count = maxCount;
}

void clCount::countDown(uint8_t ink) {
    if (count > 0)
        count=count-ink;
    else
        count = maxCount;
}

void clCount::setValue(uint8_t set) {
    count=set;
}

void clCount::doCount(uint8_t ink) {
    if(direction==UP)
    {
        if (count < maxCount)
            count=count+ink;
        else
            count = 0;
    }
    if(direction==DOWN)
    {
        if (count > 0)
        count=count-ink;
         else
        count = maxCount;
    }
}

void clCount::doCount(int8_t dir, uint8_t ink) {
    if(dir==UP)
    {
        if (count < maxCount)
            count=count+ink;
        else
            count = 0;
    }
    if(dir==DOWN)
    {
        if (count > 0)
        count=count-ink;
         else
        count = maxCount;
    }
}
// global vars and objects
BusOut boBlueLeds(LED1, LED2, LED3, LED4);
uint8_t inkr;
int richt;
InterruptIn buttondown (p12);
DigitalIn buttonleft (p13);
DigitalIn buttonclick (p14);
InterruptIn buttonup (p15);
DigitalIn buttonright (p16);

// functions
void init() {
      
}

void down()
{
    inkr--;
    if(inkr>0)
        inkr=-1;
}

void up()
{
   inkr++;
   if(inkr<0)
        inkr=1;
}


int main() {
    // local vars and objects
    clCount counterForLeds(0, 15);  // instantiate object; Objekt instanziieren (ein Exemplar der Klasse clCount erzeugen)
    inkr=1;
    richt=1;
    
    buttondown.rise(&down);  
    buttonup.rise(&up);  
   
    
    
    init();
    while(1) {
        if(buttonright==1)
             counterForLeds.changeDir(UP);
             
        if(buttonleft==1)
             counterForLeds.changeDir(DOWN);
             
        if(buttonclick==1)
            counterForLeds.setValue(0);
            
        boBlueLeds.write(counterForLeds.getValue());
        counterForLeds.doCount(inkr);
        wait(0.5); 
            
        }
        
    }


/* Erweiterungen:
- Count-Wert setzen;
- CountUp und CountDown überladen (.. bestimmten Wert rauf oder runter zählen)
- Count mit Zaehlrichtung und Inkrement
- Zählrichtung festlegen / aendern
*/