
#include "mbed.h"
#include "IM920.h"
#include "DS1820.h"
#include "Adafruit_ADS1015.h"

#define ADS1115_ADDR 0b1001000


//コンストラクタ------------------------------------------------------------------
Serial pc(USBTX, USBRX, 115200);
Serial im920_serial(p28, p27, 115200);

IM920 im920(im920_serial, pc, 115200);
DigitalIn im920_busy(p29);

DigitalOut kettle(p18);
DigitalOut pump(p19);

DS1820 ds1820(p30);

I2C m_i2c(p9, p10);
Adafruit_ADS1115 ads1115(&m_i2c, ADS1115_ADDR);
//------------------------------------------------------------------------------

//変数---------------------------------------------------------------------------
int pump_state = 0;
int kettle_state = 0;
float temp;
int pres_bit;
float pres;
//受信機側で開始時に設定
float set_temp;
float set_pres;
//------------------------------------------------------------------------------

//定数---------------------------------------------------------------------------
//圧力センサの校正係数
float a = 0.000653692;
float b = -1.548466;
//------------------------------------------------------------------------------

//無線ヘッダー--------------------------------------------------------------------
const char header_uplink = 1;
const char header_downlink = 2;
//------------------------------------------------------------------------------

//関数---------------------------------------------------------------------------
void upLink();
void downLink();
void readTemp();
void controlTemp();
void readPres();
void controlPres();
//------------------------------------------------------------------------------



// メイン関数---------------------------------------------------------------------
int main()
{
    im920.attach(&upLink, header_uplink);
    ads1115.setGain(GAIN_TWOTHIRDS);
    kettle = 0;
    pump = 0;
    pc.printf("start\r\n");

    while(1) {
        upLink();
        wait(1);
    }
}
//------------------------------------------------------------------------------


void upLink()
{
    pc.printf("wait\r\n");

    if(im920.data[1] == '0') {
        kettle = 0;
        pump = 0;
        pc.printf("stop\r\n");
    }

    else if(im920.data[1] == '1') {
        set_temp = (float)im920.toFloat(2);
        set_pres = (float)im920.toFloat(6);
        pc.printf("%f\r\n", set_temp);
        pc.printf("%f\r\n", set_pres);
        controlTemp();
        controlPres();
        downLink();
    }

}

void downLink()
{
    im920.header(header_downlink);
    im920.write((char)pump_state);
    im920.write((char)kettle_state);
    im920.write((float)temp);
    im920.write((float)pres);
    
    if(im920_busy == 0) {
        im920.send();
    }
}

void readTemp()
{
    ds1820.convertTemperature(true, DS1820::all_devices);
    temp = ds1820.temperature();
}

void controlTemp()
{
    readTemp();
    if (temp < set_temp) {
        kettle = 1;
        kettle_state = 1;
        pc.printf("kettle on :: %f[oC]\r\n", temp);
    }

    else if (temp > set_temp + 5.0) {
        kettle = 0;
        kettle_state  = 0;
        pc.printf("kettle off :: %f[oC]\r\n", temp);
    }
}

void readPres()
{
    pres_bit = ads1115.readADC_SingleEnded(0);
    pres = pres_bit * a + b;
}

void controlPres()
{
    readPres();
    if (pres < set_pres) {
        pump = 1;
        pump_state = 1;
        pc.printf("pummp on :: %f[MPa]\r\n", pres);
    }

    else if (pres > set_pres + 0.1) {
        pump = 0;
        pump_state = 0;
        pc.printf("pummp off :: %f[MPa]\r\n", pres);
    }
}

