#include "uart.h"
#include "mbed.h"
#include <string.h>
#include "motor.h"

#define BS 0x08
#define CR 0x0D
#define LF 0x0A

static      Serial  sp(p9, p10, 115200) ;// シリアルポートインスタンス：tx , rx ,ボーレート
static      char   msgBuf[63]  ={0,}    ;// 
static      UCHAR   bp         =0      ;// バッファポインタ

DigitalOut  led4(LED4);

//-------------------------------------------------------------
//受信コマンドバッファクリア
//-------------------------------------------------------------
static  void    bufClear(){
    //コマンドバッファをゼロクリア
    memset(&msgBuf[0] , 0x00 , sizeof(msgBuf) );
    //バッファポインタを先頭に戻す
    bp=0;
}

//-------------------------------------------------------------
//バックスペースが来た時の処理
//-------------------------------------------------------------
static  void    xBs(){
    msgBuf[bp] = 0x0;   //１文字消す
    if(bp>0) bp--;      //インデックスを戻す(先頭でなければ)
}
//-------------------------------------------------------------
//エンターを押したときの処理
//-------------------------------------------------------------
static  void    xEnter(){
    sp.printf("\r\n");
    sp.printf("%s\r\n" , msgBuf);
    
    if(strcmp(msgBuf , "up")==0 ){ motorTestUp();}
    if(strcmp(msgBuf , "dn")==0 ){ motorTestDown();}
    if(strcmp(msgBuf , "i")==0 ){ motorUp();}
    if(strcmp(msgBuf , "x")==0 ){ motorStop();}
    
    //バッファクリア
    bufClear();
}

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// UART 受信割り込みのコールバック
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void rxCallback()
{
    led4 = !led4;
    //1Byte抜き出す
    UCHAR buf = sp.getc();
        
    //エコーバック
    sp.putc(buf);
    
    //
    switch(buf){
        case BS :   xBs();      break;
        case CR :               break;
        case LF :   xEnter();   break; // Enter
        default :
            //コマンドバッファ格納
            msgBuf[bp] = buf;
            bp++;
            break;
    }
}

//=============================================================
//初期化
//=============================================================
void    uartInit(){
    //受信割り込みハンドラ登録
    sp.attach(rxCallback, Serial::RxIrq);

    //シリアルポート開通確認メッセージ表示
    sp.printf("***************\n");
    sp.printf("start!!!!!\n");   
    sp.printf("***************\n");
    
    //受信コマンドバッファクリア
    bufClear();
}

