#ifndef _MOTOR_H_
#define _MOTOR_H_

#include "typedef.h"

typedef union {
    UCHAR        slotl[11];//モータースロットル　0～255
    struct{
        UCHAR    MF;//Main front
        UCHAR    MB;//Main Back
        
        UCHAR    CFL ;//Cntrol Front Left
        UCHAR    CFR ;//  |      |   Right
        UCHAR    CBL ;//  |    Back  Left
        UCHAR    CBR ;//  |      |   Right 
    }id;
}MOTOR_THROTTLE;

//モーター名をCH番号にする列挙体
enum MOTOR_NAME{
    mf  =1,
    mb  =2,
    cfl =5,
    cfr =6,
    cbl =7,
    cbr =8
};

extern MOTOR_THROTTLE   mt;

//========================================================
//プロトタイプ宣言
//========================================================
void motorInit();
void motorSpiSend(UCHAR  ch ,UCHAR  val );
void motorTestUp();
void motorTestDown();
void motorUp();
void motorStop();

#endif
