#include "mbed.h"
#include "motor.h"


// ################################################################
// SPI通信フォーマットに合わせた供用体定義
//      bit |15|14|13|12|11|10| 9| 8| 7| 6| 5| 4| 3| 2| 1| 0|
// function |  KeyBit   |  ChNumber |  Motor Thlotle        |
// ################################################################
typedef union{
    UINT16  spiCmd;
    struct{    
        UINT16    val : 8;//bit[ 7: 0]
        UINT16    ch  : 4;//bit[11: 8]
        UINT16    key : 4;//bit[15:12]
    }bf;
}SPI_CMD;


// ###############################################################
// グローバル変数
// ###############################################################
static  SPI             spi (p5,p6,p7);  // mosi, miso, clk
static  DigitalOut      CS_n(p8);         //SPIのチップセレクト
static  Serial          pc      (USBTX  , USBRX );  

        MOTOR_THROTTLE  mt={0,};
static UCHAR SValue = 0;

//================================================================
//モーター制御モジュール初期化
//================================================================
void motorInit(){
    spi.format(16,3)        ;//SPIのフォーマット指定（bit長、極性）
    spi.frequency(500000)   ;//クロック周波数
    //Low有意なのでHighにしておく
    CS_n =1;
}
//----------------------------------------------------------------
//SPI送信
//----------------------------------------------------------------

void motorSpiSend
    (UCHAR  ch      //チャンネル番号
    ,UCHAR  val     //モータ設定値0～255
    )
{
    SPI_CMD cmd;
    //引数を送信するコマンドに成形
    cmd.bf.key = 0xA;   //キーbit         ：常に0xA
    cmd.bf.ch  = ch;    //チャンネル番号    :1～12が有効
    cmd.bf.val = val;   //モータースロットル :0～255
    //チップセレクトアサート
    CS_n= 0;
    //データ出力
    spi.write(cmd.spiCmd);
    //チップセレクトネゲート
    CS_n = 1;
    
    pc.printf("ch[%d] %d\r\n" , cmd.bf.ch , cmd.bf.val);
}
//================================================================
//Motor Tests
//================================================================
void motorTestUp(){
    int ch,val;
        for(ch=1; ch<3; ch++){
            for(val=0; val<30; val++){
                motorSpiSend(ch,val);
                wait(0.01);
            }
            wait(1);
        }
        for(ch=5; ch<9; ch++){
            for(val=0; val<30; val++){
                motorSpiSend(ch,val);
                wait(0.01);
            }
            wait(1);
        }
}

void motorTestDown(){
    int ch,val;
        for(ch=5; ch<9; ch++){
            for(val=30; val>0; val--){
                motorSpiSend(ch,val);
                wait(0.01);
            }
            wait(1);
        }
        for(ch=1; ch<3; ch++){
            for(val=30; val>0; val--){
                motorSpiSend(ch,val);
                wait(0.01);
            }
            wait(1);
        }
}

void motorUp(){
    int ch ,v;
    for (v=0; v<10; v++) // for each 1 unit of speed v (until 10)
    {
        if (SValue < 0xFF) // check if speed less than max
        {
            SValue++;
        }
        for(ch=1; ch<3; ch++) // each big motor
        {
            motorSpiSend(ch,SValue); // increase speed by 1 unit
            wait(0.01); // 2nd motor increases .01s after 1st motor
        }
        for(ch=5; ch<9; ch++)// each small motor
        {
            motorSpiSend(ch,SValue); // increase speed by 1 unit
            wait(0.01); // 2nd motor increases .01s after 1st motor
        }
    }
}

void motorStop(){
    int ch, v;
    for (v=SValue; v>0; v--) // for each 1 unit of speed v
    {
        for(ch=1; ch<3; ch++) // each big motor
        {
            motorSpiSend(ch,v); // decrease speed by 1 unit
            wait(0.01); // 2nd motor decreses .01s after 1st motor
        }
        for(ch=5; ch<9; ch++)// each small motor
        {
            motorSpiSend(ch,v); // decrease speed by 1 unit
            wait(0.01); // 2nd motor decreses .01s after 1st motor
        }
    }
    SValue = 0; // after motors have stopped, reset speed value
}


