#include "typedef.h"
#include "uart.h"
#include "mbed.h"
#include "globalFlags.h"

//ログ吐出し様シリアルポートインスタンス
//----------------------------------
#ifdef DEBUG_T_SERIAL
    Serial sp(USBTX, USBRX); //有線のポート
    Serial  spMoni(p13, p14);//無線モジュールを接続したポート/Outputのみ
    #define BAUD_RATE   115200
#else
//#define WIREED_SERIAL
#ifdef  WIREED_SERIAL
    Serial sp(USBTX, USBRX); //有線のポート
    #define BAUD_RATE   115200
#else
    Serial  sp(p13, p14);//無線モジュールを接続したポート
    #define BAUD_RATE   115200
#endif
#endif
//Serial sp46Axis(p28,p27);

//Asciiコード
#define CR 0x0D
#define LF 0x0A

//-------------------------------------------------------------
//グローバル変数
//-------------------------------------------------------------
char    cmdBuf[G_CMD_BUF_SIZ]    ={0,}   ;// コマンドバッファ
static  UCHAR   bp=0;// バッファポインタ

//-------------------------------------------------------------
//受信コマンドバッファクリア
//-------------------------------------------------------------
static void xBufClear(){
    memset(&cmdBuf[0] , 0x00 , sizeof(cmdBuf) );    //コマンドバッファクリア
    bp=0;                                           //バッファポインタを先頭に戻す
}
//-------------------------------------------------------------
//エンターが押されてコマンドを転送
//-------------------------------------------------------------
static void xSendMsg(){
    
    memcpy(g_CmdBuf, cmdBuf, sizeof(g_CmdBuf));
    gf_CmdPrs = true;
    xBufClear();
}
//-------------------------------------------------------------
//バックスペースが来た時の処理
//-------------------------------------------------------------
static void xBs(){
    cmdBuf[bp] = 0x0;   //現在位置をNULLにする
    if(bp>0)    bp--;   //インデックスを戻す(先頭でなければ)
}

//-------------------------------------------------------------
//コマンドバッファへ格納
//-------------------------------------------------------------
static void xPush(char cBuf){
    //バッファ終端だったらエラー
    if(bp < sizeof(cmdBuf)-1){
        cmdBuf[bp] = cBuf;//受信文字をバッファへ格納
        bp++;//次へ進める
    }
}

//-------------------------------------------------------------
//ESCが来た時の処理
//-------------------------------------------------------------
static void xEsc(){
    //バッファクリア
    xBufClear();
    //ESCをセット
    xPush(ESC);
    xSendMsg();
}

//=============================================================
// コマンドバッファへ受信キャラを格納
//=============================================================
static void xPushBuf(UCHAR iRxChar){
    switch(iRxChar){
        //▼タブ
        case 0x21: //!マーク
     //       gf.push();
            break;
        //▼バックスペース
        case BS :
            xBs();
            break;
        //▼エスケープ　キャリッジリターン
        case ESC:
            xEsc();
            break;
        case CR :
            /*何もしない*/
            break; 
        //▼ラインフィード(改行)
        case LF :
            xSendMsg();
            break;
        //▼スペース
        case SPC:
            xPush(0x0);//Null文字にしてバッファ格納
            break;
        //▼//その他
        default :
            xPush(iRxChar);//コマンドバッファへプッシュ
            break; 
    }//switch
}

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// UART 受信割り込みハンドラ
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void uartRxIntHndler(){
    //1Byte抜き出す
    UCHAR buf = sp.getc();
    //エコーバック
    sp.putc(buf);    
    //コマンドバッファに突っ込む
    xPushBuf(buf);
}

//=============================================================
//初期設定
//=============================================================
void uartInit(){
    //バッファクリア
    xBufClear();    

    //ボーレート設定
    sp.baud(BAUD_RATE);
    
    //受信割り込みハンドラ登録(登録するハンドラ,割り込み要因)
    sp.attach(uartRxIntHndler,Serial::RxIrq);
        
    sp.printf("***********\r\n");
    sp.printf("UART open!!\r\n");    
    sp.printf("-----------\r\n");
    sp.printf("INT16        = %d\r\n" ,sizeof(INT16) );
    sp.printf("unsigned int = %d\r\n" ,sizeof(unsigned int) );
    sp.printf("long         = %d\r\n" ,sizeof(unsigned long) );
    sp.printf("unsigned int = %d\r\n" ,sizeof(unsigned int) );
    sp.printf("***********\r\n");
}
