/**
* @file typedef.h
* @brief 共通で使用する型の定義
* @author Shirota, Nomura
* @date 2018/10/01 ?
*/

#ifndef _TYPEDEF_H_
#define _TYPEDEF_H_
/////////////////////////////////////////////////////////////////////
#include "debug.h"
#include <bitset>


/**
* @def G_CMD_BUF_SIZ
* @brief コマンド受け渡しバッファサイズ
* @details コマンド解析タスクで使用するコマンド受け渡しバッファサイズの定義
*/

/**
 * @def BS
 * @brief Asciiコード BackSpace(後退)
 */
#define BS  0x08
/**
 * @def HT
 * @brief Asciiコード HT(水平タブ)
 */
#define HT  0x09
/**
 * @def TAB
 * @brief Asciiコード HT(水平タブ)
 */
#define TAB 0x09
/**
 * @def LF
 * @brief Asciiコード LF(改行)
 */
#define LF  0x0A
/**
 * @def CR
 * @brief Asciiコード CR(復帰)
 */
#define CR  0x0D
/**
 * @def SPC
 * @brief Asciiコード SPC(スペース)
 */
#define SPC 0x20
/**
 * @def ESC
 * @brief Asciiコード ESC(エスケープ)
 */
#define ESC 0x1B

/**
 * @typedef UCHAR
 * @brief unsigned char のtypedef
 */
typedef unsigned char   UCHAR;
/**
 * @typedef UINT16
 * @brief unsigned short のtypedef
 */
typedef unsigned short  UINT16;
/**
 * @typedef INT16
 * @brief short のtypedef
 */
typedef short           INT16;
/**
 * @typedef UINT32
 * @brief unsigned int のtypedef
 */
typedef unsigned int    UINT32;

/**
 * @typedef typUserSw
 * @brief ユーザースイッチ(ハンドル)のレジスタ読み値のビットフィールド共用体
 */
typedef union{
    UINT16  w;
    struct{    
        UCHAR brk_l     : 1;    //!< ブレーキ左
        UCHAR flt_off   : 1;    //!< エンジンスロットル閉鎖（アイドリング）
        UCHAR r_eng_down: 1;    //!< リアエンジンスロットルをわずかに閉じる
        UCHAR r_eng_up  : 1;    //!< リアエンジンスロットルをわずかに開く
        UCHAR ctrl_sw   : 1;    //!< リザーブ1 -> ヨー角制御のON/OFF
        UCHAR brk_r     : 1;    //!< ブレーキ右
        UCHAR flt_on    : 1;    //!< エンジンスロットル開放（全開　浮上）
        UCHAR f_eng_down: 1;    //!< フロントエンジンスロットルをわずかに閉じる
        UCHAR f_eng_up  : 1;    //!< フロントエンジンスロットルをわずかに開く
        UCHAR all_stop  : 1;    //!< すべてのモーターストップ&エンジンスロットル閉鎖（アイドリング）--> 不使用
    }bf;
}typUserSw;

/**
 * @typedef typSwCounter
 * @brief ユーザースイッチ(ハンドル)のチャタリング防止用カウンターとフラグの共用体
 */
typedef union{
    UINT16  w;
    struct{    
        bool    flg     : 1;    //!< SW押されたフラグ
        UINT16  cnt    : 15;    //!< カウンター
    }bf;
}typSwCounter;

/**
* @enum ePIDMode
* @brief 使用するPIDアルゴリズムと実行のON/OFFを表すENUM
*/
enum ePIDMode{
    PID_0_OFF = 0,  //!< 高木さん修正版PID ＦＢ値計算のみ
    PID_1_OFF,  //!< PID+torgue ＦＢ値計算のみ
    PID_0_ON,  //!< 高木さん修正版PID ON
    PID_1_ON,  //!< PID+torgue ON
};

/**
 * @typedef typPidPara
 * @brief yaw回転制御用パラメータ構造体　コマンド設定用
 */
typedef struct{
    float PP;   //!< アウターループP制御系数
    float P;    //!< インナーループP制御系数
    float I;    //!< インナーループI制御系数
    float D;    //!< インナーループD制御系数
    float IMax; //!< 積分上限
    float IMin; //!< 積分下限
    float V;    //!< 機体の目標トルク算出用係数K velosity
    ePIDMode mode;
}typPidPara;

// //モーターのパラメータ構造体
// typedef struct{
//     //UCHAR num;
//     //INT16 offset;
//     INT16 limit_hi;
//     INT16 limit_low;
// }typMotPara;

/**
 * @enum DIR_TYPE
 * @brief 回転方向を表すENUM
 */
enum DIR_TYPE {
    CW,         //!< +方向
    CCW,        //!< -方向
    UNK,        //!< 不定
};
/**
 * @enum DIR_ATT_TYPE
 * @brief 回転方向が目標に近づいているのかどうかを表すENUM
 */
enum DIR_ATT_TYPE{
    CLOSING,    //!< 近づく方向
    GO_AWAY,    //!< 遠のく方向
    UNK_DIR,    //!< 不定
};

/**
 * @typedef TypeAttData
 * @brief ヨー角制御のためのログ用データの構造体　未使用
 */
typedef struct{
    float tarAng;       //ターゲット角度
    float curAng;       //現在の角度
    float curAngVelo;   //角速度
    DIR_TYPE dir;         //回転方向
    DIR_ATT_TYPE dir_att;  //ターゲット角度に向かっているかどうかの方向
}TypeAttData;

// typedef std::bitset<4> typFlg4Mot;
/////////////////////////////////////////////////////////////////////
#endif
