/**
* @file debug.h
* @brief デバッグ用のプリントをするための定義
* @author Shirota
* @date 2018/10/01 ?
*/

#ifndef __DEBUG_H__
#define __DEBUG_H__
/////////////////////////////////////////////////////////////////////
    
/**
 * @def DEBUG_ENABLE
 * @brief デバッグ用のプリントをONにするオプション
 * @details デバッグイネーブル時はシリアルポートからプリントする
 *          デバッグ無効の場合は何もしない
 */
#define DEBUG_ENABLE 
    
#ifdef DEBUG_ENABLE
    #include <stdio.h>
    #include "uart.h"
    
    #define debug(...) sp.printf( __VA_ARGS__)
    #define debugw(...) spw.printf( __VA_ARGS__)
    #define trap(...)  sp.printf("[%s : Line = %d]\r\n",__FILE__ , __LINE__);sp.printf( __VA_ARGS__)
#else
    #define debug(...) ((void)0)
    #define debugw(...) ((void)0)
    #define trap(...)  ((void)0)
#endif
    
/////////////////////////////////////////////////////////////////////
#endif
