#ifndef __IMU_H__
#define __IMU_H__

#include <iostream>
#include <vector>
#include <string>
#include <sstream>
using namespace std;
#include "mbed.h"
#include "typedef.h"

const float cGYRO_RESO=131.0;


class Imu {
private:
    Serial  sp46Axis;    //
    int32_t gyroZ;
    int32_t gyro_ref;
    //INT16   gyroZ;
    //INT16   gyro_ref;
    float   yaw;
    float   yaw_ref;
    float   yawOfset;
    float   yawRateLimit;
    
    //
    void PushBuf(UCHAR rxChar);
    void uartRxIntHndler46Axis();
    float wrapAroungGuard(float iYaw);
    float limitYawRate(float yawDiff);
public:
    Imu(PinName pinTx, PinName pinRx);
    virtual     ~Imu();
    float       GetGyroZ();
    float       GetYaw();
    float       GetYawRef();
    //INT16       GetGyroRef();
    int32_t       GetGyroRef();
    void        CalYaw();
    void        CalGyro();
};

#endif


