#ifndef __HBUSER_OPE_H__
#define __HBUSER_OPE_H__
/////////////////////////////////////////////////////////////////////
#include "typedef.h"
#include "globalFlags.h"
//#include "HbManager.h"


class HbUserOpe{
public:
    enum SW_TYPE{
        BRK_L = 0,// Front Left ブレーキ
        BRK_R,    // Front Right ブレーキ
        FLT_ON,    //エンジンスロットル開放（全開->規定値まで　浮上）
        FLT_OFF,    //エンジンスロットル閉鎖（アイドリング）
        F_ENG_UP,   //フロントエンジンスロットルをわずかに開く
        F_ENG_DOWN, //フロントエンジンスロットルをわずかに閉じる
        R_ENG_UP,   //リアエンジンスロットルをわずかに開く
        R_ENG_DOWN, //リアエンジンスロットルをわずかに閉じる
        CTRL_SW,        //Reserve 1 -> ヨー角制御ON/OFF Switch
        ALL_STOP,   //すべてのモーターストップ&エンジンスロットル閉鎖（アイドリング）
        MAX_SW_TYPE,
    };
    
private:
    typUserSw oldOpe;
    typUserSw curOpe;
    typSwCounter counter[MAX_SW_TYPE];

    float     AinAxlVal;
    float     AinTrtlVal;
    #define MAX_RPM_USERSET     9000        // ユーザーに許容する最大RPM
    #define MIN_RPM_TOTAL       1500        // おおよその最低回転可能RPM
    #define MAX_ANA_VAL         1.0         // 最大アナログ読み込み値
    #define MIN_ANA_VAL         0.0         // 最小アナログ読み込み値
    #define MAX_EFF_ANA_VAL     0.98        // アナログ読み込み値の最大有効値
    #define MIN_EFF_ANA_VAL     0.01        // アナログ読み込み値の最小有効値
    //#define MAX_12BIT_DATA      4095        // FPGAに渡すデータ(値)の最大値 --> すでにglobalFlags.hで記述済みのためコメントアウト
    #define CNT_NUM_RE   20
public:

    HbUserOpe();//コンストラクタ    
    ~HbUserOpe();//デストラクタ

    typUserSw GetUserOpe();//ボタンの現在状態取得（更新）
    float GetAinAccelRaw();
    INT16 GetAinAccel();//前進用モーター（後部）アクセル用アナログ入力値取得（更新）
    float GetAinThrottleRaw();
    INT16 GetAinThrottle();//エンジンスロットル用アナログ入力値取得（更新）
    bool ChkCtrlSW(SW_TYPE styp);
    bool ChkCtrlSwAny();
    bool ChkCtrlSwBoth(SW_TYPE styp1, SW_TYPE styp2);
    bool ChkCtrlSwRiseEdge(SW_TYPE styp);
};

/////////////////////////////////////////////////////////////////////
#endif