#include "HbUserOpe.h"
#include "fpga.h"
//=========================================
//コンストラクタ
//=========================================
HbUserOpe::HbUserOpe(){
    oldOpe.w = curOpe.w = 0;
    AinAxlVal = AinTrtlVal = 0;
    for(int i = 0; i < MAX_SW_TYPE; ++i){
        counter[i].w = 0;
    }
}

//=========================================
//デストラクタ
//=========================================
HbUserOpe::~HbUserOpe(){
}

typUserSw HbUserOpe::GetUserOpe()
{
    oldOpe = curOpe;
    curOpe.w = fpgaGetUserSw();
    if(gf_SwCmd.bf.req){
    if(gf_SwCmd.bf.req){
        UINT16 mask = 0x1;
        mask = mask << gf_SwCmd.bf.val;
        curOpe.w |= mask;
        gf_SwCmd.bf.req = false;
    }
    }
    if(gf_Print.d2.bf.sw){
        sp.printf("SW : %d%d%d%d%d%d%d%d%d%d ",curOpe.bf.brk_l,curOpe.bf.flt_off,curOpe.bf.r_eng_down,curOpe.bf.r_eng_up,curOpe.bf.ctrl_sw
                        ,curOpe.bf.brk_r,curOpe.bf.flt_on,curOpe.bf.f_eng_down,curOpe.bf.f_eng_up, curOpe.bf.all_stop);
        //sp.printf("SW : [%04X] ", curOpe.w);
    }
    return curOpe;
}
float HbUserOpe::GetAinAccelRaw()
{
    AinAxlVal = AinAxl.read();
    return AinAxlVal;
}
INT16 HbUserOpe::GetAinAccel()
{
    // max rpm 8500 ユーザー使用分として7000をマックスとする(仮)
    // 0 ~ 1.00 -> 0.01 ~ 0.97を使用する（遊び分として）
    INT16 ret = 0;
    AinAxlVal = AinAxl.read();
    if(MIN_EFF_ANA_VAL > AinAxlVal){
        ret = 0;
    } else if(AinAxlVal >= MIN_EFF_ANA_VAL && AinAxlVal <= MAX_EFF_ANA_VAL){
        ret = (MAX_RPM_USERSET - MIN_RPM_TOTAL) * (AinAxlVal - MIN_EFF_ANA_VAL) / (MAX_EFF_ANA_VAL - MIN_EFF_ANA_VAL) + MIN_RPM_TOTAL;
    } else if(AinAxlVal > MAX_EFF_ANA_VAL){
        ret = MAX_RPM_USERSET;
    }else{
        ret = 0;
    }
    if(gf_Print.d2.bf.ain == true){
        sp.printf("Axl Rpm=%d val=%f ",ret,AinAxlVal);
    }
    //sp.printf("Axl Rpm=%d val=%f\r\n",ret,anaval);
    return ret;
}

float HbUserOpe::GetAinThrottleRaw()
{
    AinTrtlVal = AinAxl.read();
    return AinTrtlVal;
}

INT16 HbUserOpe::GetAinThrottle()
{
    INT16 ret = 0;
    AinTrtlVal = AinAxl.read();
    //AinTrtlVal = AinThrottle.read();
    ret = (INT16)(MAX_VAL_12BIT * AinTrtlVal);
    if(gf_Print.d2.bf.ain == true){
        sp.printf("Trottle Val=%d analog val=%f ",ret,AinTrtlVal);
    }
    return ret;
}

bool HbUserOpe::ChkCtrlSW(SW_TYPE styp)
{
            if(styp == BRK_L)       {return curOpe.bf.brk_l;}
    else    if(styp == BRK_R)       {return curOpe.bf.brk_r;}
    else    if(styp == FLT_ON)      {return curOpe.bf.flt_on;}
    else    if(styp == FLT_OFF)     {return curOpe.bf.flt_off;}
    else    if(styp == F_ENG_UP)    {return curOpe.bf.f_eng_up;}
    else    if(styp == F_ENG_DOWN)  {return curOpe.bf.f_eng_down;}
    else    if(styp == R_ENG_UP)    {return curOpe.bf.r_eng_up;}
    else    if(styp == R_ENG_DOWN)  {return curOpe.bf.r_eng_down;}
    else    if(styp == CTRL_SW)         {return curOpe.bf.ctrl_sw;}
    else    if(styp == ALL_STOP)    {return curOpe.bf.all_stop;}
    else {return false;}
}
bool HbUserOpe::ChkCtrlSwAny()
{
    UINT16 mask = 0x1;
    for(int i = 0; i < 10; ++i){
        if(curOpe.w & mask){
            return true;
        }
        mask = mask << 1;
    }
    return false;
}
bool HbUserOpe::ChkCtrlSwBoth(SW_TYPE styp1,SW_TYPE styp2)
{
    bool sw1,sw2;
    sw1 = sw2 = false;
            if(styp1 == BRK_L)       {sw1 = curOpe.bf.brk_l;}
    else    if(styp1 == BRK_R)       {sw1 = curOpe.bf.brk_r;}
    else    if(styp1 == FLT_ON)      {sw1 = curOpe.bf.flt_on;}
    else    if(styp1 == FLT_OFF)     {sw1 = curOpe.bf.flt_off;}
    else    if(styp1 == F_ENG_UP)    {sw1 = curOpe.bf.f_eng_up;}
    else    if(styp1 == F_ENG_DOWN)  {sw1 = curOpe.bf.f_eng_down;}
    else    if(styp1 == R_ENG_UP)    {sw1 = curOpe.bf.r_eng_up;}
    else    if(styp1 == R_ENG_DOWN)  {sw1 = curOpe.bf.r_eng_down;}
    else    if(styp1 == CTRL_SW)         {sw1 = curOpe.bf.ctrl_sw;}
    else    if(styp1 == ALL_STOP)    {sw1 = curOpe.bf.all_stop;}
    else {sw1 = false;}
            if(styp2 == BRK_L)       {sw2 = curOpe.bf.brk_l;}
    else    if(styp2 == BRK_R)       {sw2 = curOpe.bf.brk_r;}
    else    if(styp2 == FLT_ON)      {sw2 = curOpe.bf.flt_on;}
    else    if(styp2 == FLT_OFF)     {sw2 = curOpe.bf.flt_off;}
    else    if(styp2 == F_ENG_UP)    {sw2 = curOpe.bf.f_eng_up;}
    else    if(styp2 == F_ENG_DOWN)  {sw2 = curOpe.bf.f_eng_down;}
    else    if(styp2 == R_ENG_UP)    {sw2 = curOpe.bf.r_eng_up;}
    else    if(styp2 == R_ENG_DOWN)  {sw2 = curOpe.bf.r_eng_down;}
    else    if(styp2 == CTRL_SW)         {sw2 = curOpe.bf.ctrl_sw;}
    else    if(styp2 == ALL_STOP)    {sw2 = curOpe.bf.all_stop;}
    else {sw2 = false;}

    return sw1 && sw2;
}

bool HbUserOpe::ChkCtrlSwRiseEdge(SW_TYPE styp)
{
    // if(counter[styp].bf.flg){
    //     ++counter[styp].bf.cnt;
    //     if(styp == BRK_L){ if(!curOpe.bf.brk_l && oldOpe.bf.brk_l){ counter[styp].bf.cnt = 0; } }
    //     if(styp == BRK_R){ if(!curOpe.bf.brk_r && oldOpe.bf.brk_r){ counter[styp].bf.cnt = 0; } }
    //     if(styp == FLT_ON){ if(!curOpe.bf.flt_on && oldOpe.bf.flt_on){ counter[styp].bf.cnt = 0; } }
    //     if(styp == FLT_OFF){ if(!curOpe.bf.flt_off && oldOpe.bf.flt_off){ counter[styp].bf.cnt = 0; } }
    //     if(styp == F_ENG_UP){ if(!curOpe.bf.f_eng_up && oldOpe.bf.f_eng_up){ counter[styp].bf.cnt = 0; } }
    //     if(styp == F_ENG_DOWN){ if(!curOpe.bf.f_eng_down && oldOpe.bf.f_eng_down){ counter[styp].bf.cnt = 0; } }
    //     if(styp == R_ENG_UP){ if(!curOpe.bf.r_eng_up && oldOpe.bf.r_eng_up){ counter[styp].bf.cnt = 0; } }
    //     if(styp == R_ENG_DOWN){ if(!curOpe.bf.r_eng_down && oldOpe.bf.r_eng_down){ counter[styp].bf.cnt = 0; } }
    //     if(styp == CTRL_SW){ if(!curOpe.bf.ctrl_sw && oldOpe.bf.ctrl_sw){ counter[styp].bf.cnt = 0; } }
    //     if(styp == ALL_STOP){ if(!curOpe.bf.all_stop && oldOpe.bf.all_stop){ counter[styp].bf.cnt = 0; } }
    //     if(counter[styp].bf.cnt > CNT_NUM_RE){
    //         counter[styp].bf.cnt = 0;
    //         counter[styp].bf.flg = false;
    //     }
    //     return false;
    // } else{
    //     if(styp == BRK_L) return counter[BRK_L].bf.flg = curOpe.bf.brk_l && !oldOpe.bf.brk_l;
    //     if(styp == BRK_R) return counter[BRK_R].bf.flg = curOpe.bf.brk_r && !oldOpe.bf.brk_r;
    //     if(styp == FLT_ON) return counter[FLT_ON].bf.flg = curOpe.bf.flt_on && !oldOpe.bf.flt_on;
    //     if(styp == FLT_OFF) return counter[FLT_OFF].bf.flg = curOpe.bf.flt_off && !oldOpe.bf.flt_off;
    //     if(styp == F_ENG_UP) return counter[F_ENG_UP].bf.flg = curOpe.bf.f_eng_up && !oldOpe.bf.f_eng_up;
    //     if(styp == F_ENG_DOWN) return counter[F_ENG_DOWN].bf.flg = curOpe.bf.f_eng_down && !oldOpe.bf.f_eng_down;
    //     if(styp == R_ENG_UP) return counter[R_ENG_UP].bf.flg = curOpe.bf.r_eng_up && !oldOpe.bf.r_eng_up;
    //     if(styp == R_ENG_DOWN) return counter[R_ENG_DOWN].bf.flg = curOpe.bf.r_eng_down && !oldOpe.bf.r_eng_down;
    //     if(styp == CTRL_SW) return counter[CTRL_SW].bf.flg = curOpe.bf.ctrl_sw && !oldOpe.bf.ctrl_sw;
    //     if(styp == ALL_STOP) return counter[ALL_STOP].bf.flg = curOpe.bf.all_stop && !oldOpe.bf.all_stop;
    //     return false;
    // }

         if (styp == BRK_L)     {   return curOpe.bf.brk_l      && !oldOpe.bf.brk_l;    }
    else if(styp == BRK_R)      {   return curOpe.bf.brk_r      && !oldOpe.bf.brk_r;    }
    else if(styp == FLT_ON)     {   return curOpe.bf.flt_on     && !oldOpe.bf.flt_on;    }
    else if(styp == FLT_OFF)    {   return curOpe.bf.flt_off    && !oldOpe.bf.flt_off;    }
    else if(styp == F_ENG_UP)   {   return curOpe.bf.f_eng_up   && !oldOpe.bf.f_eng_up;    }
    else if(styp == F_ENG_DOWN) {   return curOpe.bf.f_eng_down && !oldOpe.bf.f_eng_down;    }
    else if(styp == R_ENG_UP)   {   return curOpe.bf.r_eng_up   && !oldOpe.bf.r_eng_up;    }
    else if(styp == R_ENG_DOWN) {   return curOpe.bf.r_eng_down && !oldOpe.bf.r_eng_down;    }
    else if(styp == CTRL_SW)        {   return curOpe.bf.ctrl_sw      && !oldOpe.bf.ctrl_sw;    }
    else if(styp == ALL_STOP)   {   return curOpe.bf.all_stop   && !oldOpe.bf.all_stop;    }
    else                        {   return false;    }
}
