#ifndef __HBMOTOR_H__
#define __HBMOTOR_H__
/////////////////////////////////////////////////////////////////////
#include "typedef.h"
#include "globalFlags.h"

class HbMotor{
private:
    UCHAR   id  ;//識別ID
    INT16   ofs;//オフセットスロットル
    INT16   limitH;//
    INT16   limitL;//
    INT16   curVal;
public:
    HbMotor(UCHAR iID);//コンストラクタ
    void setValue(INT16 iVal);
    void setOfs(INT16 iVal);
    INT16 getOfs();
    void setLimit(INT16 low, INT16 hi);
    INT16 getCurrentValue();
    void setValueDirect(INT16 iVal);
    void setValueFPGA(UCHAR iID, INT16 iVal);//iIDは 0 or 1
};

class HbMotCtrl{
private:
    //std::bitset<4> ready;
    //bool    ready;
    eMotPos     pos;            // 位置
    INT16       typ;            // 流入(IN)側or出力(OUT)側
    INT16       val;            // User入力値
    INT16       attval;          // 姿勢制御の入力値
    INT16       ofs;            // オフセットスロットル値
    INT16       pwmMin;         // 
    INT16       pwmMax;         // 
    INT16       rpmMin;         // 
    INT16       rpmMax;         // 
    INT16       rpmOfs;         // 調整用オフセット
    float       rpmGain;        // 調整用ゲイン
    float       coefA;          // PWMとRPMの関係の曲線の係数A
    float       coefB;          // PWMとRPMの関係の曲線の係数B
    float       coefC;          // PWMとRPMの関係の曲線の係数C

    INT16       fpgaval;        // FPGAにセットされた0~4095の値
public:
    HbMotCtrl(eMotPos Pos, INT16 Type);//コンストラクタ
    ~HbMotCtrl();//デストラクタ

    void setPwmLimt(INT16 Min, INT16 Max);
    void setRpmLimt(INT16 Min, INT16 Max);
    void setRpmOffset(INT16 ofs);
    void setRpmGain(float gain);
    void setMotCoef(float a, float b, float c);

    INT16 calcPwm(INT16 rpm);

    void setRpmValue(eMotInType type, INT16 value);  // 値セット
    void setRpmValue(); //!< セットしたRPMの合計でFPGAに値をセット
    INT16 getRpmValue(eMotInType type);  // Rpm

    void setValFpga(INT16 value);
    INT16 getValFpga();
};

class HbSubProp{
private:
// 今回のモーターと電装ではこうなるが、変更があれば適宜変更かクラス構成の見直しが必要
#define PWN_MAX     4095
#define RPM_IN_MAX     9000
#define RPM_OUT_MAX     9000
#define RPM_MIN     1500
    eMotPos   pos  ;//識別ID
    HbMotCtrl *motCtrl[2];
    float   curVal;     // 現在のパーセンテージ
    float   tarVal;     // 目標パーセンテージ
public:
    HbSubProp(eMotPos Pos);//コンストラクタ
    ~HbSubProp();//デストラクタ

    void setRpmLimIn(INT16 min, INT16 max);
    void setRpmLimOut(INT16 min, INT16 max);
    void setPwmLimit(INT16 min, INT16 max);
    void setRpmGain(eMotType type, float gain);// 個体差吸収用ゲイン
    void setRpmOffset(eMotType type, INT16 ofs);// 個体差吸収用オフセット
    void setCoef(eMotType type, float a, float b, float c);

    void setValue(eMotInType type, INT16 val);  // rpm
    void setValue();//!< セットしたRPMの合計でFPGAに値をセット
    INT16 getValue(eMotInType type);  // rpm

    // Debug用
    void setValueFpgaMot(eMotType type, INT16 val);
    INT16 getValueFpgaMot(eMotType type);
    // あとで実装したい関数たち
    //void addValue(float val);
    //void onePush(float val);// パーセンテージ
    //void setValueEMG(float val);    // オフセット分も含めて指定可能
};


/////////////////////////////////////////////////////////////////////
#endif