#ifndef __HBMANAGER_H__
#define __HBMANAGER_H__
/////////////////////////////////////////////////////////////////////
#include "typedef.h"
#include "HbEngine.h"
#include "HbAttitude.h"
#include "HbMotor.h"
#include "Imu.h"
#include "HbUserOpe.h"




/////////////////////////////////////////////////
class HbManager{
private:
    INT16       en_srv_step[2];         //!< エンジンスロットルを変化させる際のステップ値
    INT16       en_srv_adj_step[2];     //!< エンジンを浮上中にドライバーが調整する際のステップ値
    INT16       motorOfsVal[4] ;        //!< 姿勢制御用のオフセット
    INT16       mot_brk;                //!< MotorブレーキのRPM値
    INT16       mot_takeoff_offset;     //!< モーターのTAKE_OFFステート時に使用するオフセット値
    UINT16      accelVal[2] ;//
    float       ang_rate_brk;           //!< ブレーキボタンON時の目標角度[deg]変化率
    float       nowTrgtAng; //目標ヨー角
    float       nowAngle    ;//現在ヨー角
    float       nowRate     ;//現在加速度
    typUserSw   usrSW       ;//ユーザー操作SW
    //メンバクラス
    HbEngine    *eng[2]     ;//エンジン制御クラス
    HbAttitude  *att        ;//姿勢制御クラス
    //HbMotor     *mot[4]     ;//モーター制御クラス
    HbSubProp   *subProp[4]     ;//モーター制御クラス
    Imu         *imu        ;//慣性計測装置

    HbUserOpe   *ope        ;//ユーザー操作

    //INT16       motVal;     // モーターチェック用モーター値
    //short       motNum;     // モーターチェック用モーター番号

public:
    HbManager();
    // TestSPIRead Task生存証明用アクセスProof of survival
    UINT16 proofOfSurvival();
    // Attitude
    void getAttitude();
    void calAtt();
    void controlAttitude();
    void controlAttitude(float cmdAngle);
    void setAttPara(typPidPara para);
    // Motor
    void controlMotor();
    void addMotVal(eMotPos pos, INT16 add);
    void subMotVal(eMotPos pos, INT16 add);
    INT16 getCurMotVal(eMotPos pos);
    void setMotVal(eMotPos pos, INT16 val);
    void setMotValOfs(eMotPos pos, INT16 val);
    void setMotValAtt(eMotPos pos, INT16 val);
    void setMotTakeOffOffset();
    void setFpgaMot(eMotPos pos,eMotType type, INT16 val);
    //void setMotFPGA(UCHAR num, INT16 val);

    // Engine
    void getEngine();
    void controlEngine();
    void controlEngine(enmHbState stat);
    
    void clearHvAxl();
    bool chkSetHvAxl(eEgPos pos);
    void setHvAxl(eEgPos pos, INT16 val);
    INT16 getHvAxl(eEgPos pos);
    void setAccelVal(eEgPos pos, INT16 val);
    INT16 getAccelVal(eEgPos pos);
    
    void getUserCommand();
    INT16 getUserMotAxl();
    INT16 getUserEngTrottle();
    float getUserMotAxlRaw();
    float getUserEngTrottleRaw();
    
    bool chkOverIDLE();
    bool chkInRangeIDLE();
    void chkSW(enmHbState stat);
    bool chkSWUserOpe(HbUserOpe::SW_TYPE stype);
    bool chkSWUserOpeRE(HbUserOpe::SW_TYPE stype);//立ち上がり検出
    bool chkSWUserOpeAny();
    bool chkSWUserOpeBoth(HbUserOpe::SW_TYPE stype1, HbUserOpe::SW_TYPE stype2);
    
    typUserSw getUserSw();
};

/////////////////////////////////////////////////////////////////////
#endif
