#include "HbEngine.h"
#include "fpga.h"
#include "globalFlags.h"
//======================================================
//コンストラクタ
//======================================================
HbEngine::HbEngine(UCHAR iID){
    id = iID;
    accel = 0;
    hvAxl = 3600;
    bSetHvAxl = false;
}


UINT16  HbEngine::getRpm(){
    UINT16  rpm;
    //エンジン回転数読み出し
    //if(id<0||id>1)return 0;//現在の使用状況では不要
    if(id == 0){
        rpm = fpgaGetRpm(true);//前
    }else/*if(id == 1)*/{
        rpm = fpgaGetRpm(false);//後
    }
    return rpm;
}

//アクセル設定
void HbEngine::setAccel(UINT16 iVal){
    accel = iVal > MAX_VAL_12BIT ? MAX_VAL_12BIT : iVal;
    fpgaEngine(id,accel);
}

INT16 HbEngine::getAccel(){
    INT16 ret;
    if(accel < 0){
        ret = 0;
    }else if(accel > MAX_VAL_12BIT){
        ret = MAX_VAL_12BIT;
    } else {
        ret = accel;
    }
    return ret;
}

void HbEngine::setHoverAccel(INT16 val){
    hvAxl = val;
    bSetHvAxl = true;
}

void HbEngine::clearHoverAccel(){
    hvAxl = 0;
    bSetHvAxl = false;
}

INT16 HbEngine::getHoverAccelVal(){
    return hvAxl;
}

bool HbEngine::chkSetHoverAccel(){
    return bSetHvAxl;
}

bool HbEngine::chkOverIDLECycle(){
    return rpm > IDLE_HI;
}

bool HbEngine::chkInRangeIDLE(){
    return rpm > IDLE_LOW && rpm < IDLE_HI;
}
