#ifndef __HBATTITUDE_H__
#define __HBATTITUDE_H__
/////////////////////////////////////////////////////////////////////
#include "typedef.h"


class HbAttitude {
private:
    float   p     ;//アウターループP制御系数
    float   kp    ;//インナーループP制御系数
    float   ki    ;//インナーループI制御系数
    float   kd    ;//インナーループD制御系数
    float   kv    ;//Pp -> t 期待の目標トルク算出用係数K velosity
    float   limitH;//積分上限
    float   limitL;//積分下限
    float   sum   ;//積分値
    float   old   ;//1サンプル前のデータ(微分用)
    float   oAng  ;//1サンプル前の角度
public:
    HbAttitude(float iPo , float iP , float iI , float iD);//コンストラクタ
    //virtual ~HbAttitude();//デストラクタ
    float pid(float iCmdAng, float iCurAng , float iRate);
    float pid2(float iCmdAng, float iCurAng , float iRate);

    void resetValue();
    float getPp();
    float getP();
    float getI();
    float getD();
//    float getT();
    float getV();
    void setPp(float iPp);
    void setP(float iP);
    void setI(float iI);
    void setD(float iD);
//    void setT(float iT);
    void setV(float iV);
    void setIMax(float val);
    void setIMin(float val);
};


/////////////////////////////////////////////////////////////////////
#endif