#include "Utils.h"
#include "USBHost.h"
#include "hci.h"
#include "ps3.h"
#include "User.h"

#include "mbed.h"

//ここに関数外に書く要素を記入する
int RSX,RSY,LSX,LSY,BSU,BSL;
//PwmOut led1(LED1);
//PwmOut led2(LED2);

DigitalOut led3(LED3);
DigitalOut led4(LED4);

PwmOut wheelR1(p21);
PwmOut wheelR2(p22);

PwmOut wheelL2(p23);
PwmOut wheelL1(p24);

PwmOut launch1(p25);
PwmOut launch2(p26);


void motorR(int dir,float dutyR)

{
    if(dir==1)
            {
                wheelR1=dutyR;
                wheelR2=0;
            }
            
    else if(dir==2)
            {
                wheelR2=dutyR;
                wheelR1=0;
            }
            
    else if(dir==0)
            {
                wheelR1=0;
                wheelR2=0;
            }
            
}

void motorL(int dir,float dutyL)
{
    if(dir==1)
            {
                wheelL1=dutyL;
                wheelL2=0;
            }
            
    else if(dir==2)
            {
                wheelL1=0;
                wheelL2=dutyL;
            }
            
    else if(dir==0)
            {
                wheelL1=0;
                wheelL2=0;
            }
        
}
 
 

void UserLoopSetting()
{
    //led1.period_ms(20);
    //一度だけ行いたい初期設定をここに書く
    
}

void UserLoop(char n,const u8* data)
{
    u16 ButtonState;
    if(n==0)
            {//有線Ps3USB.cpp
                RSX = ((ps3report*)data)->RightStickX;
                RSY = ((ps3report*)data)->RightStickY;
                LSX = ((ps3report*)data)->LeftStickX;
                LSY = ((ps3report*)data)->LeftStickY;
                BSU = (u8)(((ps3report*)data)->ButtonState & 0x00ff);
                BSL = (u8)(((ps3report*)data)->ButtonState >> 8);
            //ボタンの処理
                ButtonState =  ((ps3report*)data)->ButtonState;
            }
    else 
            {//無線TestShell.cpp
                RSX = ((ps3report*)(data + 1))->RightStickX;
                RSY = ((ps3report*)(data + 1))->RightStickY;
                LSX = ((ps3report*)(data + 1))->LeftStickX;
                LSY = ((ps3report*)(data + 1))->LeftStickY;
                BSU = (u8)(((ps3report*)(data + 1))->ButtonState & 0x00ff);
                BSL = (u8)(((ps3report*)(data + 1))->ButtonState >> 8);
            //ボタンの処理
                ButtonState =  ((ps3report*)(data + 1))->ButtonState;
            }
    //ここより下にプログラムを書く
    //データ取得例
   
    
    
    if((ButtonState >> BUTTONUP)&1) 
            {
                motorL(1,0.6);
                motorR(1,0.6);       
            }
            
    else if((ButtonState >> BUTTONLEFT)&1)
            {
                motorL(1,0.4);
                motorR(1,0.8);
            }
        
    else if((ButtonState >> BUTTONRIGHT)&1)
            {
                motorL(1,0.8);
                motorR(1,0.4);                
            }
            
    else if((ButtonState >> BUTTONDOWN)&1)
            {
                motorL(2,0.6);
                motorR(2,0.6);
            }
                
    else if((ButtonState >> BUTTONR1)&1)
            {
                motorL(1,0.6);
                motorR(2,0.6);
            }
                    
    else if((ButtonState >> BUTTONL1)&1)
            {
                motorL(2,0.6);
                motorR(1,0.6);
            }
            
    else if((ButtonState >> BUTTONSQUARE)&1)
            {
                launch1=0.9;
                launch2=0;
            }
    
    else if((ButtonState >> BUTTONCROSS)&1)
            {
                launch1=0;
                launch2=0.9;
            }
            
    else if((ButtonState >> BUTTONCROSS)&1)   
            { 
                if((ButtonState >> BUTTONSQUARE)&1)
                    {
                        launch1=0;
                        launch2=0;
                    }                                 
            } 
            
    else if((ButtonState >> BUTTONSQUARE)&1)  
            { 
                if((ButtonState >> BUTTONCROSS)&1)
                    {
                        launch1=0;
                        launch2=0;
                
                    }
            
            }                            
        
        
 //ここより下にANALOGのプログラムを書く  
     //ここより下にANALOGのプログラムを書く  
     
 //left up  , right up        
    else  if(LSX/256.0f>0.3 && LSX/256.0f<0.7 && LSY/256.0f<0.3 &&
             RSX/256.0f>0.3 && RSX/256.0f<0.7 && RSY/256.0f<0.3)
             {
                motorR(1,0.9);
                motorL(1,0.9);
             }
                                            
 //left down, right down
                                            
    else if(LSX/256.0f>0.3 && LSX/256.0f<0.7 && LSY/256.0f>0.7 &&
            RSX/256.0f>0.3 && RSX/256.0f<0.7 && RSY/256.0f>0.7)
            {
                motorR(2,0.9);
                motorL(2,0.9);
            }
                                          
//  left up  , right down 
    else if(LSX/256.0f>0.3 && LSX/256.0f<0.7 && LSY/256.0f<0.3 &&
            RSX/256.0f>0.3 && RSX/256.0f<0.7 && RSY/256.0f>0.7)
            {
                motorL(1,0.9);
                motorR(2,0.9);
            }
                                                    
// left down, right up
                                                    
    else if(LSX/256.0f>0.3 && LSX/256.0f<0.7 && LSY/256.0f>0.7 &&
            RSX/256.0f>0.3 && RSX/256.0f<0.7 && RSY/256.0f<0.3)
            {
                motorL(2,0.9);
                motorR(1,0.9);
            }
                                        
                                       
    else    { 
                  motorL(0,0);
                  motorR(0,0);
                  launch1=0;
                  launch2=0;
            }
       
    
    //led1=LSX/256.0f;
    //led2=LSY/256.0f;
    led3=ButtonState & 0x0400;  //L1の状態
    led4=ButtonState & 0x0800;  //R1の状態
    //値の取得はps3.hを参照
}

