#include "mbed.h"
#include "Arduino.h"


Arduino::Arduino(PinName tx, PinName rx) : _arduino(tx,rx){
    _arduino.baud(9600);
}
void Arduino::sendCommand(char com){
    //_arduino.clc();
    _arduino.printf("&c",  com);
}

int Arduino::receiveData(){
    char value[100];
    int index=0;
    char ch;
    do
    { 
    if (_arduino.readable())      // if there is an character to read from the device
    {
        ch = _arduino.getc();   // read it
        if (index<99)               // just to avoid buffer overflow
            value[index++]=ch;  // put it into the value array and increment the index
        }
    } while (ch!='\n');    // loop until the '\n' character
 
    value[index]='\x0';  // add un 0 to end the c string
    return atoi(value);
}

int Arduino::getLdrY(){
    sendCommand('y');
    return this->receiveData();
}

int Arduino::getLdrX(){
    sendCommand('x');
    return receiveData();
}

int Arduino::getColor(){
    sendCommand('c');
    return receiveData();
}

int Arduino::getOrientation(){
    sendCommand('a');
    return receiveData();
}

