#include "config.h"
#include "log.h"
#include "HttpSend.h"
#include "mbed.h"

#define BUFFER_NUM 64

Queue<message_t, BUFFER_NUM>    m_queue;
message_t m_mpool[BUFFER_NUM]={0};
int m_queueCnt=0;
EthernetInterface* m_ethernet;
osThreadId m_send_thread;
TCPSocketConnection m_sock;

message_t* getBuffer(){
    for(int i=0 ; i < BUFFER_NUM ; i++){
        if( m_mpool[i].used == false ){
            m_mpool[i].used = true;
            return &m_mpool[i];
        }
    }
    return NULL;
}

void releaseBuffer(message_t* buf){
    memset(buf->data,0,sizeof(buf->data));
    buf->used=false;
}

void sendData(char* data, size_t length){
    char http_cmd[256];

    sprintf(http_cmd,"POST /whiteserver/PostData HTTP/1.1\r\n");
    sprintf(http_cmd,"%sUser-Agent: sample-app\r\n",http_cmd);
    sprintf(http_cmd,"%sHost: %s\r\n",http_cmd,SERVER_HOST);
    sprintf(http_cmd,"%sContent-Length: %d\r\n",http_cmd,length);
    sprintf(http_cmd,"%sContent-Type: application/x-www-form-urlencoded\r\n",http_cmd);
    sprintf(http_cmd,"%s\r\n%s",http_cmd,data);

    
//    DEBUG_LOG("------------- DATA ---------------\n%s\n",http_cmd);
//    DEBUG_LOG("(size=%d:%s",length,data);
    m_sock.send_all(http_cmd, strlen(http_cmd));

/* 結果は受けない。POSTするのみにしておく
    DEBUG_LOG("sock.send_all ret=%d \n",ret);
    char buffer[300];
    while (true) {
        ret = sock.receive(buffer, sizeof(buffer)-1);
        DEBUG_LOG("sock.receive ret=%d \n",ret);
        if (ret <= 0){
            break;
        }
        buffer[ret] = '\0';
        INFO_LOG(" Received ret=%d \n chars from server :\n%s\n", ret, buffer);
    }
*/    
    //sock.close();
}

    
void send_thread (void const *argument) {
    INFO_LOG ("send_thread start\n");

    while (true) {
        osEvent evt = m_queue.get();
        if (evt.status == osEventMessage) {
            message_t *message = (message_t*)evt.value.p;
            if(message!=NULL && message->size!=0 ){
//                DEBUG_LOG("(size=%d)(m_queueCnt=%d):%s",message->size,m_queueCnt,message->data);
                DEBUG_LOG("(size=%d)(m_queueCnt=%d)\n",message->size,m_queueCnt);
//                INFO_LOG ("IP Address is %s \n", m_ethernet->getIPAddress());
                sendData(message->data, message->size);
//                m_ethernet->disconnect();
                //m_mpool.free(message);
                releaseBuffer(message);
                m_queueCnt--;
//                DEBUG_LOG ("*message=0x%08X free \n",message);
            }else{
                DEBUG_LOG("message ??? \n");
            }
        }
        Thread::wait(100);
    }
        
    // unreachable INFO_LOG ("send_thread end\n");
}


osThreadDef(send_thread,  osPriorityNormal, DEFAULT_STACK_SIZE);

void HttpSend::init(EthernetInterface* eth){
    INFO_LOG ("HttpSend::init start\n");
    m_ethernet = eth;
    m_ethernet->connect();
    int ret = m_sock.connect(SERVER_HOST, SERVER_HOST_PORT);  
    m_send_thread = osThreadCreate(osThread(send_thread), NULL);
    INFO_LOG ("HttpSend::init end\n");
}

message_t* HttpSend::getMessageBuffer(){
    return getBuffer();
}

void HttpSend::send(message_t* message){
    m_queueCnt++;
    m_queue.put(message);
}


