#include "mbed.h"
#include "config.h"
#include "log.h"
#include "HttpSend.h"

Serial bleModule(p9,p10);

DigitalOut led1(LED1);
DigitalOut led2(LED2);

HttpSend m_httpsend;

message_t *m_message;
unsigned char serialBufferLoc = 0;

void rxInterrupt() {
    if( serialBufferLoc==0 ){
        led1=true;
        m_message = m_httpsend.getMessageBuffer();
    }
    led2=!led2;
    m_message->data[serialBufferLoc] = LPC_UART3->RBR;
//    LPC_UART0->RBR = m_message->data[serialBufferLoc];
    if( m_message->data[serialBufferLoc] == '\n' ){
        if(// "004C " or "004c "
           m_message->data[0]=='0' && 
           m_message->data[1]=='0' && 
           m_message->data[2]=='4' && 
           (m_message->data[3]=='C'||m_message->data[3]=='c') &&  
           m_message->data[4]==' ' &&
           // "1502 "
           m_message->data[5]=='1' && 
           m_message->data[6]=='5' && 
           m_message->data[7]=='0' && 
           m_message->data[8]=='2' &&  
           m_message->data[9]==' ') 
        {
            m_message->data[serialBufferLoc+1]=NULL;
            m_message->size = serialBufferLoc+1;
            m_httpsend.send(m_message);
        }

        led2=false;
        led1=false;
        serialBufferLoc=0;
    }else{
        serialBufferLoc++;
    }
}

int main() {
    INFO_LOG ("UD1_LanGateway start !!!\n");

    /*************************/
    // Initialize
    /*************************/
    // EthernetInterface
    EthernetInterface eth;
    eth.init();

    // HttpSend
    m_httpsend.init(&eth);

    // Serial
    bleModule.baud(115200);

    bleModule.attach(&rxInterrupt);
    while(true) {
        wait(0.5);
    }
    // unreachable INFO_LOG ("UD1_LanGateway stop !!!\n"); 
}
