#include "mbed.h"
#include "rtos.h"

//Serial pc(USBTX, USBRX); // tx, rx
DigitalIn en_1(p15);
DigitalIn en_2(p16);
AnalogIn ea_1(p19);
AnalogIn ea_2(p20);

// pout vérification d'échantionnage avec oscilloscope
DigitalOut sn_test(p18);

#define POTENTIOMETRE 1
#define BOUTON 0
#define SIGNAL_ANALOG 0x2
#define SIGNAL_NUM 0x1

Ticker sample;

// variable globale pour lecture button 1
int previousStateButton1 = 0;
int currentStateButton1;
int validationStateButton1;

// variable globale pour lecture button 2
int previousStateButton2 = 0;
int currentStateButton2;
int validationStateButton2;

// variable globale pour lecture potentiometre 
int tab_counter  =0;
int Nouvelle_moyenne_p19;
int Ancienne_moyenne_p19 = 0;
int Nouvelle_moyenne_p20;
int Ancienne_moyenne_p20 = 0;
unsigned short Tableau_Moyenne_p19[5]={0,0,0,0,0};
unsigned short Tableau_Moyenne_p20[5]={0,0,0,0,0};

int ISRcounter = 0;

Thread *threadNumerique;    // pointeur vers le thread du lecture numérique 
Thread *threadAnalogique;   // pointeur vers le thread du lecture analogique 
Thread *threadCollection;   // pointeur vers le thread d'affichage d'evenement  

// Pour le time stamp
char buffer[32];
struct tm * timeinfo;

// structure de data
typedef struct {
    time_t seconds;
    int pinNumero;
    int info;
    bool type; // 
} data;

// Create queue
Queue<data, 32> queue;

// Create memory pool
MemoryPool<data, 32> mpool;

// osEvent to get from queue
osEvent evt;

// Thread pour lecture analogique 
void lecture_analog(void const *args) {
    //int counterRTC = 0;
    while (true) 
    {
        Thread::signal_wait(SIGNAL_ANALOG);   // WAITING STATE (waiting for an event)
    /*
        if(counterRTC == 500)
        {
            time_t seconds = time(NULL);
            printf("\n\r");
            printf("valider les frequences dechantillonnage pour analogique \n\r");
            printf("Nombre de secondes passer pour 500 iterations = %d\n\r", seconds);
            printf("Secondes/iterations = %f\n\r", ((float)seconds/500));
        }
        counterRTC++;
    */    
        // create data structure
        data *analogData;
        
        Tableau_Moyenne_p19[tab_counter] = ea_1.read_u16(); //= LIRE PATTE 8 ;
        Tableau_Moyenne_p20[tab_counter] = ea_2.read_u16(); //= LIRE PATTE 8 ;
        
        if(tab_counter % 5 == 0)    // validation duree de 1.25 seconde sont terminée
        {
        Nouvelle_moyenne_p19 = (int)Tableau_Moyenne_p19[0]+(int)Tableau_Moyenne_p19[1]+(int)Tableau_Moyenne_p19[2]+(int)Tableau_Moyenne_p19[3]+(int)Tableau_Moyenne_p19[4];
        Nouvelle_moyenne_p20 = (int)Tableau_Moyenne_p20[0]+(int)Tableau_Moyenne_p20[1]+(int)Tableau_Moyenne_p20[2]+(int)Tableau_Moyenne_p20[3]+(int)Tableau_Moyenne_p20[4];
        }

        // vérification de la difference de la moyenne de 12.5% pour les 2 potentiometres 
        if((Ancienne_moyenne_p19 - Nouvelle_moyenne_p19) > 40960 || (Nouvelle_moyenne_p19 - Ancienne_moyenne_p19) > 40960 || (Ancienne_moyenne_p20 - Nouvelle_moyenne_p20) > 40960 || (Nouvelle_moyenne_p20 - Ancienne_moyenne_p20) > 40960)
        {
        // associte data structure to memory pool
        analogData = mpool.alloc();
        
        if((Ancienne_moyenne_p19 - Nouvelle_moyenne_p19) > 40960 || (Nouvelle_moyenne_p19 - Ancienne_moyenne_p19) > 40960)
        {
            analogData->pinNumero = 19;  
            analogData->info = (Nouvelle_moyenne_p19/5);
        }
        if((Ancienne_moyenne_p20 - Nouvelle_moyenne_p20) > 40960 || (Nouvelle_moyenne_p20 - Ancienne_moyenne_p20) > 40960)
        {
            analogData->info = (Nouvelle_moyenne_p20/5);
            analogData->pinNumero = 20;      
        }
        
        analogData->type = POTENTIOMETRE; 
        analogData->seconds = time(NULL); 
        queue.put(analogData);
        }
      
        // mise a jour de l'ancienne moyenne pour les 2 potentiometres
        if(tab_counter % 5 == 0)
        {      
            Ancienne_moyenne_p20 = Nouvelle_moyenne_p20;
            Ancienne_moyenne_p19 = Nouvelle_moyenne_p19;
        }
        
        tab_counter = tab_counter % 5 + 1; // incrémentation de i
}
}

// Thread pour lecture numérique 
void lecture_num(void const *args) 
{
    //int counterRTC = 0;
    while (true) 
    {    
        Thread::signal_wait(SIGNAL_NUM);   // WAITING STATE (waiting for an event)
        /*
        if(counterRTC == 1000)
        {
            time_t seconds = time(NULL);
            printf("\n\r");
            printf("valider les frequences dechantillonnage pour numerique\n\r");
            printf("Nombre de secondes passer pour 1000 iterations = %d\n\r", seconds);
            printf("Secondes/iterations = %f\n\r", ((float)seconds/1000));
        }
        counterRTC++;
        */
        // create data structure
        data *numData;
        
        currentStateButton1 = en_1.read();  // lecture courante numérique button 1
        currentStateButton2 = en_2.read(); // lecture courante numerique button 2
    
        if(previousStateButton1 != currentStateButton1 || previousStateButton2 != currentStateButton2)   // détection de changement d'état pour les 2 buttons
        {    
            Thread::wait(50);    // période de stabilisation de 50ms
        
            validationStateButton1 = en_1.read();   // nouvelle lecture apres stabilisation button 1
            validationStateButton2 = en_2.read();   // nouvelle lecture apres stabilisation button 2
        
            if(currentStateButton1 == validationStateButton1 || currentStateButton2 == validationStateButton2)  
            {   
                // associte data structure to memory pool
                numData = mpool.alloc();
                 
                if(previousStateButton1 != currentStateButton1)
                {
                    numData->pinNumero = 15;
                    numData->info = currentStateButton1;
                }
                    
                if(previousStateButton2 != currentStateButton2)
                {
                    numData->pinNumero = 16;
                    numData->info = currentStateButton2;
                }
    
                numData->type = BOUTON;
                numData->seconds = time(NULL); 
                queue.put(numData);
            } 
            
        }
        previousStateButton1 = validationStateButton1; // mise a jour de l'état précédente button 1
        previousStateButton2 = validationStateButton2; // mise a jour de l'etat precedente button 2
    }
}

// Thread pour afficher les evenements 
void collection(void const *args) {
while (true) {
     
     // get data from queue and store in evt
     evt = queue.get();
     // error check
     if (evt.status == osEventMessage) {
            // retrive information from queue to data structure
            data *dataDisplay = (data*)evt.value.p;
            
            printf("Pin numero = %d \t", dataDisplay->pinNumero);
            // conversion des secondes en format AA:MM:JJ:HH:MM:SS
            timeinfo = localtime(&dataDisplay->seconds);
            
            //strftime(buffer, 32, "%y:%m:%d:%H:%M:%S \n\r", localtime(&dataDisplay->seconds));
            //printf("Time as a custom formatted string = %s\n\r", buffer);
            
            printf ("Current local time and date: %d:%.2d:%.2d:%.2d:%.2d:%.2d \t", (1900 + timeinfo->tm_year),(timeinfo->tm_mon + 1), (timeinfo->tm_mday), timeinfo->tm_hour, timeinfo->tm_min, timeinfo->tm_sec);
            
            if(dataDisplay->type == POTENTIOMETRE)
            {
                printf("Moyenne courante = %d \t\n\r", dataDisplay->info);
            }
            
            if(dataDisplay->type == BOUTON)
            {
                printf("etat = %d \t\n\r", dataDisplay->info);
            }
            
            mpool.free(dataDisplay);    // free memory pool
     }
}
}


// sampling timer 
void interuptTimer() 
{
    if (ISRcounter % 2 == 0) //permet échantillonage chaque 100ms car detecter 1 fois sur 2 
    {
    threadNumerique->signal_set(SIGNAL_NUM); //event occurs to trigger in response to signal waiting state
    }
 
    if (ISRcounter % 5 == 0) ////permet échantillonage chaque 250ms
    {
    threadAnalogique->signal_set(SIGNAL_ANALOG); //event occurs to trigger in response to signal waiting state
    }
    
    ISRcounter++;
}

int main() {
    set_time(1505829060);  // Set RTC time to today
    
    Thread thread1;     //Create thread 1, READY state 
    threadNumerique = &thread1;     
    
    Thread thread2;     //Create thread 2, READY state 
    threadAnalogique = &thread2;
    
    Thread thread3;     //Create thread 3, READY state 
    threadCollection = &thread3; 
    
    threadNumerique->start(callback(lecture_num, (void *)NULL)); // RUNNING state
    
    threadAnalogique->start(callback(lecture_analog, (void *)NULL)); // RUNNING state
    
    threadCollection->start(callback(collection, (void *)NULL)); // RUNNING state
    
    //set_time(0);  // Set RTC time to debut de la terre
    sample.attach(&interuptTimer, 0.05); // période d'échantillonage chaque 50ms
    while(1) {}
}

