/**** Vincent Labbé - labv2507  *****/
/**** Karan Kalsi - kalk2701  *****/
#include "mbed.h"    
#include "MMA8452Q.h"

Serial xbee_routeur(p13,p14);
Serial pc(USBTX, USBRX); // tx, rx
DigitalOut rst1(p8); //Digital reset for the XBee, 200ns for reset
DigitalIn btn(p15); //Bouton read
//MMA8452Q mma8452(p9,p10,0x1d);

LocalFileSystem local("local");               // Create the local filesystem under the name "local"
DigitalOut myled(LED1);
Ticker sample;
int currentStateButton;
int previousStateButton;
int validationStateButton;

uint16_t panId;  // panId
uint8_t panId_LSB;
uint8_t panId_MSB;

char*   url;    // url
char URL[10];

void seperatePanId(void);
void ReadFile (void);
void envoyer_tramme(char commande[], uint8_t data[], uint8_t length_MSB, uint8_t length_LSB, uint8_t API_frame_name);
void transmisson(uint8_t data[], uint8_t length_MSB, uint8_t length_LSB, uint8_t API_frame_name);
void initialisation_xbee(void);
void readBtn(void);

int main() { 
 
    ReadFile();// when you run first time without this line, the setup file is on created
    wait(1);
    seperatePanId(); // séparé msb et lsb du panId
    
    /*
    pc.printf("panId lsb : %x\n\r",panId_LSB);
    pc.printf("panId msb : %x\n\r",panId_MSB);
    pc.printf("panId : %x\n\r",panId);
    pc.printf("url: %s\n\r",URL);
    */
    
    initialisation_xbee();
    
    char commande0[2] = {'I','D'};
    uint8_t data0[2] = {panId_MSB, panId_LSB};
    envoyer_tramme(commande0, data0, 0x00, 0x06, 0x09);
    
    char commande1[2] = {'S','C'};
    uint8_t data1[2] = {0x09};
    envoyer_tramme(commande1, data1, 0x00, 0x05, 0x09);
    
    /*
    char commande2[2] = {'W','R'};
    uint8_t data2[10] = {};
    envoyer_tramme(commande2, data2, 0x00, 0x04, 0x09);
    */
    /*
    char commande3[2] = {'A','C'};
    uint8_t data3[2] = {};
    envoyer_tramme(commande3, data3, 0x00, 0x04, 0x09);
    */
    
    sample.attach(&readBtn,0.05);
    
    while(1)
    {   
    
    
    
    //myled = 1;
    if(xbee_routeur.readable())
    {
     pc.putc(xbee_routeur.getc());   
    }
    
    if(pc.readable())
    {
     xbee_routeur.putc(pc.getc());   
    }

    }
}

void readBtn(void)
{
    uint8_t data4[2];
    currentStateButton = btn.read();  // lecture courante numérique button 
    
        if(previousStateButton != currentStateButton)   // détection de changement d'état pour bouton
        {    
            wait_ms(50);
            
            validationStateButton = btn.read();   // nouvelle lecture apres stabilisation button 
            
            if(currentStateButton == validationStateButton)  
            {        
                if(previousStateButton != currentStateButton)
                {
                    if(currentStateButton == 1)
                    {
                    data4[0] = 0x01;
                    }
                    else
                    {
                    data4[0] = 0x00;
                    }
                    transmisson(data4, 0x00, 0x0F, 0x10);
                }
            }
        }
        previousStateButton = validationStateButton; // mise a jour de l'état précédente button 1
}

void initialisation_xbee(void)
{
    xbee_routeur.baud(9600); //set baud rate
    rst1 = 0;   // xbee reset
    wait_ms(400);
    rst1 = 1;
    xbee_routeur.printf("+++");
    wait_ms(500);
}

void transmisson(uint8_t data[], uint8_t length_MSB, uint8_t length_LSB, uint8_t API_frame_name)
{
    int sum = 0;
    
    xbee_routeur.putc(0x7E); // start delimiter
    xbee_routeur.putc(length_MSB); // MSB length
    xbee_routeur.putc(length_LSB); // LSB length
    xbee_routeur.putc(API_frame_name); // API frame name 
    xbee_routeur.putc(0x01); // Frame Id
    xbee_routeur.putc(0x00); // 64-bit address (broadcast)  
    xbee_routeur.putc(0x00); // 
    xbee_routeur.putc(0x00); // 
    xbee_routeur.putc(0x00); // 
    xbee_routeur.putc(0x00); // 
    xbee_routeur.putc(0x00); // 
    xbee_routeur.putc(0x00); // 
    xbee_routeur.putc(0x00); // 
    xbee_routeur.putc(0xFF); // 16-bit address (broadcast)
    xbee_routeur.putc(0xFE); // 16-bit address (broadcast)
    xbee_routeur.putc(0x00); // Broadcast radius
    xbee_routeur.putc(0x00); // Options
    
    uint16_t length = length_MSB;
    length = (length << 8) + length_LSB;
    //pc.printf("length : %x\n\r",length);
    
    for (int i = 0 ; i < length - 14; i++)
    {
        xbee_routeur.putc(data[i]); // API frame name 
        //pc.printf("data %d : %x\n\r",i,data[i]);
        sum = sum + data[i]; 
    }
    
    sum = sum + API_frame_name + 0x01 + 0xFF +0xFE;
    char checksum = (0xFF - (sum & 0xFF));
    //pc.printf("checksum : %x\n\r",checksum);
    xbee_routeur.putc(checksum); // checksum
}


void envoyer_tramme(char commande[], uint8_t data[], uint8_t length_MSB, uint8_t length_LSB, uint8_t API_frame_name)
{
    int sum = 0;
    
    xbee_routeur.putc(0x7E); // start delimiter
    xbee_routeur.putc(length_MSB); // MSB length
    xbee_routeur.putc(length_LSB); // LSB length
    xbee_routeur.putc(API_frame_name); // API frame name 
    xbee_routeur.putc(0x01); // Frame Id
    xbee_routeur.putc(commande[0]); // Commande lettre 1
    xbee_routeur.putc(commande[1]); // Commande lettre 2
    
    uint16_t length = length_MSB;
    length = (length << 8) + length_LSB;
    //pc.printf("length : %x\n\r",length);
    
    for (int i = 0 ; i < length - 4; i++)
    {
        xbee_routeur.putc(data[i]); // API frame name 
        //pc.printf("data %d : %x\n\r",i,data[i]);
        sum = sum + data[i]; 
    }
    
    sum = sum + API_frame_name + 0x01 + commande[0]+ commande[1];
    char checksum = (0xFF - (sum & 0xFF));
    //pc.printf("checksum : %x\n\r",checksum);
    xbee_routeur.putc(checksum); // checksum
}

void seperatePanId(void)
{
    panId_LSB = (panId & 0x00FF);
    panId_MSB = ((panId >> 8) & 0x00FF);
}

void ReadFile (void) 
{
    FILE *set = fopen("/local/config.txt", "r");  // Open "setup.txt" on the local file system for read
    fscanf(set,"%x",&panId); // read offset
    fscanf(set,"%s %f",URL,&url);   // read gain
    fclose(set);
}





























// SPI COMMUNICATION
/*
int main() {

     float x, y, z ;
     MMA8452Q acc(p9,p10,0x1d);     // acceleration object
     
         cs = 0;    //Clear display SPI
         wait(0.1);
         spi.write(0x76); // Clear display
         cs = 1;
         wait(0.1);
         cs = 1;
         
     while (true) {       
         x = acc.getAccX() ; 
         y = acc.getAccY() ;
         z = acc.getAccZ() ;
         printf("X[%.3f] Y[%.3f] Z[%.3f]\n",x, y, z) ;
         wait(0.1);

        int X = x * 1000; //Pour enlever floating point et garder une précision
        int Y = y * 1000;
        int Z = z * 1000;

        int angle = (1000-(((2*X*X+2*Y*Y)*1000/(X*X+Y*Y+Z*Z)))); //Calcul vectoriel pour calculer l'angle à l'horizontal
        
        pc.printf("avant acos = %d", angle);
        
        float ratioZaccel = angle/1000.0; //Remettre en floating point pour acos
        int resultatRAD = 500*acos((ratioZaccel)); //Reponse en RAD
        
        pc.printf("valeur rad new= %d", resultatRAD);
        int degree = resultatRAD * 18000/31400; //Tranfo degree
        pc.printf("valeur deg new = %d", degree);
        pc.printf("valeur deg new = %d", degree);
        
        // extracting digits
        int digit;
        int digits[4] = {0,0,0,0};
        int i = 0;
        while(degree > 0) {
        digit = degree % 10; //to get the right most digit
        digits[i]=digit;
        pc.printf("digit %d = %d, degree int: %d", i, digits[i], degree);
        degree /= 10;              //reduce the number by one digit
        ++i;
        }
         
         spi.write(0x77); // Decimal control command    // Pour la communication SPI
         cs = 1;
         wait(0.01);
         cs = 0;
         spi.write(0x04);// Turn on decimal
         cs = 1;
         wait(0.01);
         cs = 0;
         spi.write(digits[3]);
         cs = 1;
         wait(0.01);
         cs = 0;
         spi.write(digits[2]);
         cs = 1;
         wait(0.01);
         cs = 0;
         spi.write(digits[1]);
         cs = 1;
         wait(0.01);
         cs = 0;
         spi.write(digits[0]);
         cs = 1; 
         */
         /*     Test
         cs = 0;
         wait(0.1);
         spi.write(0x5);
         cs = 1;
         */
    //    }
//} 



// UART COMMUNICATION
/*
void UARTInit()
{
 uint16_t usFdiv;   
    
 LPC_SC->PCONP       |=  (1 << 25);  // Power up the UART3 it's disabled on powerup.
  
 LPC_PINCON->PINSEL1 |= (3 << 18);   // Pin P0.25 used as TXD0 (Com0)     // Enable the pins on the device to use UART3 
 LPC_PINCON->PINSEL1 |= (3 << 20);   // Pin P0.26 used as RXD0 (Com0) 
    
 LPC_SC->PCLKSEL1    &= ~(3 << 18); // Clean all to 0    // Setup the PCLK for UART3
 LPC_SC->PCLKSEL1    |=  (1 << 18); // PCLK = CCLK

 LPC_UART3->LCR  =   0x83;  // 0000 0000 1000 0011       // Word select 8-bit character length and set DLAB

 usFdiv = (SystemCoreClock / (16*9600));    //Baud rate calculation
 LPC_UART3->DLM  =  usFdiv / 256;
 LPC_UART3->DLL  =   usFdiv % 256;

 LPC_UART3->FCR       = 0x7;     // Enable and reset UART3 FIFOs.

 LPC_UART3->LCR &= ~(1 << 7);    // Clear DLAB
}

char UART3Transmit(int out)
{
    LPC_UART3 -> THR = out;
    while(! (LPC_UART3->LSR & (0x01 << 0x06)));

    return 1;
}

int main() {
    
 UARTInit();

     float x, y, z ;
    
     MMA8452Q acc(p9,p10,0x1d);     // acceleration object
         
         UART3Transmit(0x76); // Clear display UART
     while (true) {  
          
         x = acc.getAccX() ; 
         y = acc.getAccY() ;
         z = acc.getAccZ() ;
         printf("X[%.3f] Y[%.3f] Z[%.3f]\n",x, y, z) ;
         wait(0.1);

        int X = x * 1000; //Pour enlever floating point et garder une précision
        int Y = y * 1000;
        int Z = z * 1000;

        int angle = (1000-(((2*X*X+2*Y*Y)*1000/(X*X+Y*Y+Z*Z)))); //Calcul vectoriel pour calculer l'angle à l'horizontal
        
        pc.printf("avant acos = %d", angle);
        
        float ratioZaccel = angle/1000.0; //Remettre en floating point pour acos
        int resultatRAD = 500*acos((ratioZaccel)); //Reponse en RAD
        
        pc.printf("valeur rad new= %d", resultatRAD);
        int degree = resultatRAD * 18000/31400; //Tranfo degree
        pc.printf("valeur deg new = %d", degree);
        
        pc.printf("valeur deg new = %d", degree);
        
        
        int digit;      // extracting digits
        int digits[4] = {0,0,0,0};
        int i = 0;
        while(degree > 0) {
        digit = degree % 10; //to get the right most digit
        digits[i]=digit;
        pc.printf("digit %d = %d, degree int: %d", i, digits[i], degree);
        degree /= 10;              //reduce the number by one digit
        ++i;
        }
         
         UART3Transmit(0x77); // Decimal control command    // Pour la communication UART
         UART3Transmit(0x04);// Turn on decimal
         
         UART3Transmit(digits[3]);
         UART3Transmit(digits[2]);
         UART3Transmit(digits[1]);
         UART3Transmit(digits[0]);      //UART3Transmit(0xA5);
        }
} 
*/        


/* // communication I2C 
Serial pc(USBTX, USBRX); // tx, rx
I2C i2c(p9,p10);   

int main() {
    i2c.frequency(100000);
    char cmd[2] = {0,0};
    int addr = 0x5A;
    int data = 0xA4;
    cmd[0] = addr;
    cmd[1] = data;
    
while(1){
    i2c.write(0x3A,cmd,2);
    wait_ms(5);
    }
}
 */
// I2C write
//i2c.frequency(100000);
//int cmd[0] = 0x0D;
//12c.write(addr,cmd,1,true);
//i2c.read(addr,cmd,1);

 /* // communication UART
Serial pc(USBTX, USBRX); // tx, rx
Serial mc(p9,p10);
int main() {
    
    int nombre;
    pc.printf("Entrez un nombre de 4 chiffres : ");
    pc.scanf("%d", &nombre);
    pc.printf("Votre numero entrez est le : %d", nombre);
    //mc.printf(nombre);
    mc.putc(nombre);
}
 */

/*
DigitalOut myled(LED3);

int main() {
    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
*/

// I2C write
/*
I2C    i2c( p28, p26 );        // sda, scl
 
int main() {
    char    data[3];
 
    data[0]   = 0x16;
    data[1]   = 0x55;
    data[2]   = 0x55;
 
    i2c.write( 0xC0, data, 3 ); //0xC0 is slave adress 
}*/

// I2C Read
/*
short read_sensor_lower_8bit( void )
{
    char    v;
    char    cmd;
 
    cmd    = 0x05;
 
    i2c.write( 0x88, &cmd, 1 );
    i2c.read( 0x88, &v, 1 );
 
    return( v );
}
*/

/*
int main() {
    set_time(1256729737);  // Set RTC time to Wed, 28 Oct 2009 11:35:37
}*/

/*
int main() {
    while(1) {
        time_t seconds = time(NULL);

        printf("Time as seconds since January 1, 1970 = %d\n", seconds);

        printf("Time as a basic string = %s", ctime(&seconds));

        char buffer[32];
        strftime(buffer, 32, "%I:%M %p\n", localtime(&seconds));
        printf("Time as a custom formatted string = %s", buffer);

        wait(1);
    }
}*/
/*
int main() {

    // get the current time from the terminal
    struct tm t;
    printf("Enter current date and time:\n");
    printf("YYYY MM DD HH MM SS[enter]\n");    
    scanf("%d %d %d %d %d %d", &t.tm_year, &t.tm_mon, &t.tm_mday
                             , &t.tm_hour, &t.tm_min, &t.tm_sec);

    // adjust for tm structure required values
    t.tm_year = t.tm_year - 1900;
    t.tm_mon = t.tm_mon - 1;
    
    // set the time
    set_time(mktime(&t));
        
    // display the time
    while(1) {    
        time_t seconds = time(NULL);
        printf("Time as a basic string = %s", ctime(&seconds));
        wait(1);
    }
}*/