#include "mbed.h" //normal library
#include "mcp4725.h" //DAC library
#include "TextLCD.h" //16x2 lcd library
#include "math.h" //math library
 
TextLCD lcd(p14, p13, p21, p22, p23, p24, TextLCD::LCD16x2); //setup for 16x2 lcd (rs, e, d4-d7)
Serial pc(USBTX, USBRX); //serial usb communication setup
AnalogIn analogIn(p15); //used for testing in original code
MCP4725 DAC(p28, p27, MCP4725::Standard100kHz, 0); //init the DAC module
//define custom characters
const char sin_char_top[]  = { 0x0, 0xe,0x11,0x11, 0x0, 0x0, 0x0, 0x0}; //makes left part of sin wave char
const char sin_char_bot[]  = { 0x0, 0x0, 0x0, 0x0,0x11,0x11, 0xe, 0x0}; //makes right part of sin wave char
const char sq_char_left[]  = {0x1c, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x7}; //makes left part of square wav char
const char sq_char_right[] = { 0x7, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4,0x1c}; //makes right part of square wav char
const double pi = 3.14159; //needed constant for sin()
int main() {
    //set custom characters to empty char spot
    lcd.setUDC(0, (char *) sin_char_bot); //set to char 0
    lcd.setUDC(1, (char *) sin_char_top); //set to char 1
    lcd.setUDC(2, (char *) sq_char_left); //set to char 2
    lcd.setUDC(3, (char *) sq_char_right); //set to char 3
    int RUN = 0; //start = 1, stop = 0
    int SIGNAL_MODE = 0; //1sin,10ksin,1sq,10ksq = 0,1,2,3

    while(1) { //start continuous loop
        int dots = 0; //for waiting loop
        while(RUN == 0)
            {
                lcd.setCursor(TextLCD::CurOff_BlkOff); //set cursor to invisible
                lcd.setAddress(0, 0); //place cursor at origin
                lcd.printf("Waveform: off\n"); //print to lcd that it is in off mode
                if(dots == 0){
                    lcd.printf("waiting   ");
                    dots++;
                    }
                else if(dots == 1){
                    lcd.printf("waiting.  ");
                    dots++;
                    }
                else if(dots == 2){
                    lcd.printf("waiting.. ");
                    dots++;
                    }
                else if(dots == 3){
                    lcd.printf("waiting...");
                    dots = 0;
                    } //makes the dots go "." ".." "..." in a loop 
                else{
                    lcd.printf("ERROR CASE"); //print to show error
                    }
                wait_ms(1000); //lower frequency loop to cycle dots at 0.1 second interval
            }
        int i = 0; //resets counter when transitioning from stop to start
        while(RUN == 1) //waveform is being generated
            {
                //set display on
                lcd.setCursor(TextLCD::CurOff_BlkOff); //set cursor to invisible
                lcd.setAddress(0, 0); //place cursor at origin
                lcd.printf("Waveform: on\n"); //print that the waveform is on
                
                if(SIGNAL_MODE == 0){
                    //sin wave 1Hz or 1s
                    lcd.putc(0); lcd.putc(1); lcd.printf("1Hz Sin Wav");
                    
                    double j = 1.65*sin(2*pi*i/100)+1.65; //formula to plot a sin wave from 0 to 3.3V over 100 points
                    DAC.write(MCP4725::Normal, (0xFFF * (j/3.3)), false); //send value to the DAC
                    wait_ms(10); //going from 0 to 2pi over 100 points -> 1 second/100
                    i++; //increment to the next point
                    } //end if case
                else if(SIGNAL_MODE == 1){
                    //sin wave 10kHz or 100us
                    lcd.putc(0); lcd.putc(1); lcd.printf("10kHz Sin Wav");
                    
                    double k = 1.65*sin(2*pi*i/100)+1.65; //formula to plot a sin wave from 0 to 3.3V over 100 points
                    DAC.write(MCP4725::Normal, (0xFFF * (k/3.3)), false); //send value to the DAC
                    wait_us(1); //going from 0 to 2pi over 100 points -> 100 usecond/100
                    i++; //increment to the next point
                    } //end if case
                else if(SIGNAL_MODE == 2){
                    //square wave 1Hz or 1s
                    lcd.putc(2); lcd.putc(3); lcd.printf("1Hz Sq Wav");
                    
                    DAC.write(MCP4725::Normal, 0xFFF, false); //set to max value
                    wait_ms(500); //wait half the period
                    DAC.write(MCP4725::Normal, 0x000, false); //set to min value
                    wait_ms(500); //wait half the period
                    } //end if case
                else if(SIGNAL_MODE == 3){
                    //square wave 10kHz or 100us
                    lcd.putc(2); lcd.putc(3); lcd.printf("10kHz Sq Wav");
                    
                    DAC.write(MCP4725::Normal, 0xFFF, false); //set to max value
                    wait_us(50); //wait half the period
                    DAC.write(MCP4725::Normal, 0x000, false); //set to min value
                    wait_us(50); //wait half the period
                    } //end if case
                else{
                    lcd.printf("ERROR CASE"); //print to show error
                    //do nothing
                    } //end default
            } //end while(on) loop
    } //end while(1) loop
} //end main
