
#include "mbed.h"
#include "I2C_SSD1306Z.h" 
#include "logo.h"

I2C i2c(I2C_SDA, I2C_SCL);


InterruptIn speedsig(D2); //define and name the interrupt input
InterruptIn rpmsig(D3); //define and name the interrupt input
DigitalOut pulse(D13);
DigitalOut pulse1(D12);
float t_period = 0;                   // This is the period between interrupts in microseconds
Timer t,tr;
long timing,timingr,oldvalue,oldtiming,speed=0;
int count1=0,count2=0;
//P//wmOut output(led);
void ISR1() { //this is the response to interrupt, i.e. the ISR
   if(speed<175)
   {    pulse=1;
        pulse1=1;
   }
   else
   {    count1++; 
        if(count1>1)
        {   pulse=1;
            pulse1=1;
            count1=0;
        }     
    }       
   timing=t.read_us();   
}
void ISR2() { //this is the response to interrupt, i.e. the ISR
    if(speed<175)
   {    pulse=0;
        pulse1=0;
   }
   else
   {    count2++; 
        if(count2>1)
        {   pulse=0;
            pulse1=0;
            count2=0;
        }     
    }       
   t.reset();
}

void ISR3() { //this is the response to interrupt, i.e. the ISR
      timingr=tr.read_us();
       tr.reset();   
}

int main()
{
   char buffer [20];
   speedsig.fall(&ISR1); // attach the address of the ISR function to the
    speedsig.rise(&ISR2); // attach the address of the ISR function to the   
    rpmsig.rise(&ISR3); // attach the address of the ISR function to the  
    wait(0.5);
    t.start(); //start timer
    tr.start();
    Init_LCD();
    draw_LCD(NISSAN);
    wait(2.0);
    clear_LCD();
     print_Line(0, "  Speed and Rev");
     print_Line(1, "      Meter    ");
     print_Line(2, "       by: Miji");
     print_Line(3, "  ************* ");
     wait(2.0);  
    clear_LCD();
    draw_LCD(B13);
    wait(2.0);
    clear_LCD();
    while(1) {        
        int  rpm=30000000/timingr;
        long freq_m=100000000/(timing*4);
        speed=(freq_m*63)/1067;
        if(tr.read()>0.3f)  // timeout
            rpm=0;
        if(t.read()>0.8f)   // timeout
            speed=0;    
        if(speed<2 || speed>300)
            speed=0;
         sprintf(buffer,"Speed: %3d kmh " ,speed);
        print_Line(0, buffer);
        if(rpm<300 || rpm >10000)
            rpm=0;
        sprintf(buffer,"Rev: %5d rpm" ,rpm);
        print_Line(2, buffer);
        wait(0.3);
     
    }
}

/*
int main()
{
    confSysClock();     //Configure system clock (72MHz HSE clock, 48MHz USB clock)
    
    printf("init oled\n");
    
    Init_LCD();
    clear_LCD();
 
  while (1) {
 
   
     draw_LCD(B13);
     wait(2.0);
     clear_LCD();
     print_Line(0, "IT Maker Space");
     print_Line(1, "ARM mbed RTOS");
     print_Line(2, "ST Micro");
     print_Line(3, "ittraining.com");  
     wait(2.0);
     clear_LCD();

   }

}*/


