#include "mbed.h"
Serial pc(USBTX, USBRX);
BusOut Seg1(PC_9,PC_8,PB_8,PC_6,PB_9,PC_5,PA_5,PA_12);// A,B,C,D,E,F,G,DP
BusOut Seg2(PA_8,PB_1,PB_10,PB_15,PB_4,PB_14,PB_5,PB_13);// A,B,C,D,E,F,G,DP
char SegConvert(char SegValue); // functionprototype

void SegInit(void); // function prototype
void HostInit(void); // function prototype
char GetKeyInput(void); // function prototype
char data1, data2; // variable declarations

int main() 
{ // main program
    SegInit(); // call function to initialise the 7-seg displays
    HostInit(); // call function to initialise the host terminal
        while (1) 
        { // infinite loop
            data2 = GetKeyInput(); // call function to get 1st key press
            Seg1=SegConvert(data2); // call function to convert and output
            data1 = GetKeyInput(); // call function to get 2nd key press
            Seg2=SegConvert(data1); // call function to convert and output
            pc.printf(" "); // display spaces between 2 digit numbers
        }
}

char SegConvert(char SegValue) { // function 'SegConvert'
char SegByte=0x00;
switch (SegValue) { //DPGFEDCBA
case 0 : SegByte = 0x3F;break; // 00111111 binary
case 1 : SegByte = 0x06;break; // 00000110 binary
case 2 : SegByte = 0x5B;break; // 01011011 binary
case 3 : SegByte = 0x4F;break; // 01001111 binary
case 4 : SegByte = 0x66;break; // 01100110 binary
case 5 : SegByte = 0x6D;break; // 01101101 binary
case 6 : SegByte = 0x7D;break; // 01111101 binary
case 7 : SegByte = 0x07;break; // 00000111 binary
case 8 : SegByte = 0x7F;break; // 01111111 binary
case 9 : SegByte = 0x6F;break; // 01101111 binary
   }
    return SegByte;
}

void SegInit(void) {
Seg1=SegConvert(0); // initialise to zero
Seg2=SegConvert(0); // initialise to zero
}

void HostInit(void) {
pc.printf("\n\rType two digit numbers to be displayed on the 7-seg display\n\r");
}

char GetKeyInput(void) {
char c = pc.getc(); // get keyboard data (note numerical ascii range 0x30-0x39)
pc.printf("%c",c); // print ascii value to host PC terminal
return (c&0x0F); // return value as non-ascii (bitmask c with value 0x0F)
}