// TAK Server

#include "mbed.h"
#include "EthernetInterface.h"
 
#define SERVER_PORT   23
 
 DigitalOut myled1(LED1);
 DigitalOut myled2(LED2);
 DigitalOut myled3(LED3);
 DigitalOut myled4(LED4);
 DigitalOut RelayLED(p5);
 DigitalOut RelayPUMP(p6);
 
int main (void) {
    EthernetInterface eth;
    //eth.init(); //Use DHCP
    static const char*     mbedIp       = "192.168.0.102";  //IP
    static const char*     mbedMask     = "255.255.255.0";  // Mask
    static const char*     mbedGateway  = "192.168.0.1";    //Gateway
    eth.init(mbedIp,mbedMask,mbedGateway); //Use  these parameters for static IP
    eth.connect();
    printf("\nServer IP Address is %s\n", eth.getIPAddress());
    
    TCPSocketServer server;
    server.bind(SERVER_PORT);
    server.listen();
    
    while (true) {
        printf("\nWait for new connection...\n");
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(false, 15000); // Timeout after (15)s
        
        printf("Connection from: %s\n", client.get_address());
        char buffer[256];
        while (true) {
            int n = client.receive(buffer, sizeof(buffer));
            if (n <= 0) break;            
            // print received message to terminal
            buffer[n] = '\0';
            printf("Received message from Client :'%s'\n",buffer);
            
            // reverse the message
            char temp;
            for(int f = 0, l = n-1; f<l; f++,l--){
                temp = buffer[f];
                if(temp=='1')
                {
                            myled1 = 1;
                            myled2 = 1;
                            myled3 = 1;
                            myled4 = 1;
                }
                if(temp=='0')
                {
                            myled1 = 0;
                            myled2 = 0;
                            myled3 = 0;
                            myled4 = 0;
                }
                if(temp=='5')
                {
                            RelayLED = !RelayLED;
                }
                if(temp=='6')
                {
                            RelayPUMP = !RelayPUMP;
                }
                buffer[f] = buffer[l];
                buffer[l] = temp;
                }
            
            // print reversed message to terminal
            printf("Sending message to Client: '%s'\n",buffer);
            
            // Echo received message back to client
            client.send_all(buffer, n);
            if (n <= 0) break;
        }
        
        client.close();
    }
}
 