#include "mbed.h"
#include "DebounceIn.h"
// must import Cookbook Debounce library into project
// URL: http://mbed.org/users/AjK/libraries/DebounceIn/lky9pc

Serial pc(USBTX, USBRX);

DigitalOut myled1 (p12);
DigitalOut myled2 (p13);
DigitalOut myled3 (p14);
DigitalOut myled4 (p15);

DebounceIn pb1(p8);
DebounceIn pb2(p9);
DebounceIn pb3(p10);
DebounceIn pb4(p11);

int count = 0;
int order = 0;
int reset = 0;

int old_pb1 = 0;
int old_pb2 = 0;
int old_pb3 = 0;
int old_pb4 = 0;

int new_pb1;
int new_pb2;
int new_pb3;
int new_pb4;

int level=1;
void level1();
void level2();
int tries = 0;

// SPST Pushbutton count demo using internal PullUp function
// no external PullUp resistor needed
// Pushbutton from P8 to GND.
// Demonstrates need for debounce - will not count more than once per button hit
// This ocuurs on all switches due to mechanical contact bounce

int main()
{
    // Use internal pullup for pushbutton
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    pb3.mode(PullUp);
    pb4.mode(PullUp);
    // Delay for initial pullup to take effect
    wait(.001);
    char c = pc.getc();
    if (c=='l' && tries==0){
    if (level==1) level1();
    tries=0;
    if (level==2) level2();
}
}


void level1()
{
    while(1)
    {
        myled2 = 1; wait(0.5);
        myled1 = 1; wait(0.5);
        myled3 = 1; wait(0.5);
        myled4 = 1; wait(0.5);
        myled2 = 0; wait(0.5);
        myled1 = 0; wait(0.5);
        myled3 = 0; wait(0.5);
        myled4 = 0; wait(0.5);

    while(1)
    {
        new_pb1 = pb1;
        new_pb2 = pb2;
        new_pb3 = pb3;
        new_pb4 = pb4;
    
    if(((new_pb1 == 0) && (old_pb1 == 1)) || ((new_pb2 == 0) && (old_pb2 == 1)) || ((new_pb3 == 0) && (old_pb3 == 1) || ((new_pb4 == 0) && (old_pb4 == 1) )))
    {  
        count++;
        switch(order)
        {
            case 0:
            {
                if((new_pb2 == 0) && (old_pb2 == 1) && (tries<4))
                { myled2 = 1; order = 1; reset = 0;}
                else {reset = 1; tries++;}
            } break;
            case 1:
            {
                if((new_pb1 == 0) && (old_pb1 == 1) && (tries<4))
                { myled1 = 1; order = 2; reset = 0;}
                else {reset = 1; tries++;}
            } break;
            case 2:
            {
                if((new_pb3 == 0) && (old_pb3 == 1) && (tries<4))
                { myled3 = 1; order = 3; reset = 0;}
                else {reset =1; tries++;}
            } break;
            case 3:
            {
                if((new_pb4 == 0) && (old_pb4 == 1) && (tries<4))
                { myled4 = 1; order = 0; level=2; wait(3); reset=2;}
                else {reset =1; tries++;}
            } break;
        }
        if (tries<4){
        if (reset == 1)
        {order = 0; myled1 = 0; myled2 = 0; myled3 = 0; myled4=0; wait(1); break;}
        if (reset ==2)
        {order = 0; myled1=0; myled2=0; myled3=0; myled4=0; wait(1); return;}
    }
        if (tries>3)
        {order = 0; myled1=0; myled2=0; myled3=0; myled4=0; wait(1); return;}
            
    }
    
    old_pb1 = new_pb1;
    old_pb2 = new_pb2;
    old_pb3 = new_pb3;
    old_pb4 = new_pb4;
    }
    }
}
void level2()
{
    while(1)
    {
        myled3 = 1; wait(0.25);
        myled4 = 1; wait(0.25);
        myled2 = 1; wait(0.25);
        myled1 = 1; wait(0.25);
        myled3 = 0; wait(0.25);
        myled4 = 0; wait(0.25);
        myled2 = 0; wait(0.25);
        myled1 = 0; wait(0.25);

    while(1)
    {
        new_pb1 = pb1;
        new_pb2 = pb2;
        new_pb3 = pb3;
        new_pb4 = pb4;
    
    if(((new_pb1 == 0) && (old_pb1 == 1)) || ((new_pb2 == 0) && (old_pb2 == 1)) || ((new_pb3 == 0) && (old_pb3 == 1) || ((new_pb4 == 0) && (old_pb4 == 1) )))
    {  
        count++;
        switch(order)
        {
            case 0:
            {
                if((new_pb3 == 0) && (old_pb3 == 1) && tries<4)
                { myled3 = 1; order = 1; reset = 0;}
                else {reset = 1; tries++;}
            } break;
            case 1:
            {
                if((new_pb4 == 0) && (old_pb4 == 1) && tries<4)
                { myled4 = 1; order = 2; reset = 0;}
                else {reset = 1; tries++;}
            } break;
            case 2:
            {
                if((new_pb2 == 0) && (old_pb2 == 1) && tries<4)
                { myled2 = 1; order = 3; reset = 0;}
                else {reset =1; tries++;}
            } break;
            case 3:
            {
                if((new_pb1 == 0) && (old_pb1 == 1) && tries<4)
                { myled1 = 1; order = 0; level=1; wait(3); reset=2;}
                else {reset =1; tries++;}
            } break;
        }
        if (tries<4){
        if (reset == 1)
        {order = 0; myled1 = 0; myled2 = 0; myled3 = 0; myled4=0; wait(1); break;}
        if (reset ==2)
        {order = 0; myled1=0; myled2=0; myled3=0; myled4=0; wait(1); return;}
    }
        if (tries>3)
        {order = 0; myled1=0; myled2=0; myled3=0; myled4=0; wait(1); return;}
    }
    
    old_pb1 = new_pb1;
    old_pb2 = new_pb2;
    old_pb3 = new_pb3;
    old_pb4 = new_pb4;
    }
    }
}