#include "mbed.h"
#include "DebounceIn.h"
#include "stdint.h"
#include "MCP23017.h"
#include "WattBob_TextLCD.h"
#include "VL6180.h"
#include "TCS3472_I2C.h"

#define     BACK_LIGHT_ON(INTERFACE)    INTERFACE->write_bit(1,BL_BIT)
#define     BACK_LIGHT_OFF(INTERFACE)   INTERFACE->write_bit(0,BL_BIT)

MCP23017            *par_port;
WattBob_TextLCD     *lcd;

#define IDENTIFICATIONMODEL_ID 0x0000

Serial PC(USBTX, USBRX); //default 9600 baud
VL6180  TOF_sensor(p28, p27);
TCS3472_I2C rgb_sensor(p9, p10);

DigitalOut servo11 (p8); DigitalOut servo12 (p7);
DigitalOut servo13 (p6); DigitalOut servo14 (p5);

DigitalOut servo21 (p29); DigitalOut servo22 (p23);
DigitalOut servo23 (p22); DigitalOut servo24 (p21);

DigitalOut servo31 (p26); DigitalOut servo32 (p25);  
DigitalOut servo33 (p12); DigitalOut servo34 (p11); 

DigitalOut myled1 (p13);    DigitalOut myled2 (p14);
DigitalOut myled3 (p15);    DigitalOut myled4 (p16);

DebounceIn pb1(p17);    DebounceIn pb2(p18);
DebounceIn pb3(p19);    DebounceIn pb4(p20);

int old_pb1 = 0, old_pb2 = 0, old_pb3 = 0, old_pb4 = 0;
int new_pb1,     new_pb2,     new_pb3,     new_pb4;

int i = 0, col, row, led; //variables for order manipulation
int levelreset, tries, level = 1; //level parameters
float delay; //delay for blinking LEDs
int D = 30; //for distance sensor

int order[24][4] = //ORDER ARRAY FOR LED GAME
{1,2,3,4,   2,1,3,4,    3,1,2,4,    1,3,2,4,    2,3,1,4,    3,2,1,4,
 4,2,1,3,   2,4,1,3,    1,4,2,3,    4,1,2,3,    2,1,4,3,    1,2,4,3,
 1,3,4,2,   3,1,4,2,    4,1,3,2,    1,4,3,2,    3,4,1,2,    4,3,1,2,
 4,3,2,1,   3,4,2,1,    2,4,3,1,    4,2,3,1,    3,2,4,1,    2,3,4,1};

void LEDgame(); //function prototype of LED game
void reset(); //to reset level
void light(int); //turn on LEDs
void Maint(); // maintainence mode
int Dist(); //check distance sensor
int MAX(int,int,int); //find max rgb value

int main()

{
    pb1.mode(PullUp);   pb2.mode(PullUp);
    pb3.mode(PullUp);   pb4.mode(PullUp);
    wait(.001);
    
    par_port = new MCP23017(p9, p10, 0x40);
    par_port->config(0x0F00, 0x0F00, 0x0F00);           //configure MCP23017 chip on WattBob
    lcd = new WattBob_TextLCD(par_port);
    BACK_LIGHT_ON(par_port);
    TOF_sensor.VL6180_Init();
    rgb_sensor.enablePowerAndRGBC();
    rgb_sensor.setIntegrationTime(100);
    int rgb_read[4], maxrgb;
    while (1){
    char c = PC.getc();
    if (c == 'o'){
    while(1)
    {
        rgb_sensor.getAllColors(rgb_read);
        maxrgb = MAX(rgb_read[1],rgb_read[2],rgb_read[3]);
        if (maxrgb == rgb_read[1])
        //if (maxrgb > 2000 && maxrgb < 3000)
        while(level <= 4 && Dist() < D)
        {
            if (level == 0) break; //to stop game if level reset to zero.
            row = rand()%24;
            tries = 1;
            LEDgame();
        }
        if (Dist() > D) {
            level = 1;
            myled1=0; myled2=0; myled3=0; myled4=0;
            } //resets game if card is removed.
    }
}

    else if (c== 'm'){
        while (1){
            char d = PC.getc();
            if (d=='D') {PC.printf("%d", Dist());}
            if (d=='C'){
                rgb_sensor.getAllColors(rgb_read);
                maxrgb = MAX(rgb_read[1],rgb_read[2],rgb_read[3]);
                if (maxrgb == rgb_read[1]) PC.puts("Red");
                else if (maxrgb == rgb_read[2]) PC.puts("Green");
                else if (maxrgb == rgb_read[3]) PC.puts("Blue");
                }
            else if (d=='r') myled1=1;
            else if (d=='y') myled2=1;
            else if (d=='g') myled3=1;
            else if (d=='w') myled4=1;
            else if (d=='s') {LEDgame();}
            else if (d=='d') {myled1=0; myled2=0; myled3=0; myled4=0; }  
            else if (d=='o'){
                    while(1){
                    char p=PC.getc();
                    if (p=='f') servo11=1;
                    else if (p=='s') servo12=1;
                    else if (p=='t') servo13=1;
                    else if (p=='F') servo14=1;
                    else if (p=='R'){
                        servo11=0; servo12=0; servo13=0; servo14=0;
                        break;
                    }
                    }
                }
            else if (d=='S'){
                    while(1){
                    char p=PC.getc();
                    if (p=='f') servo21=1;
                    else if (p=='s') servo22=1;
                    else if (p=='t') servo23=1;
                    else if (p=='F') servo24=1;
                    else if (p=='R'){
                        servo21=0; servo22=0; servo23=0; servo24=0;
                        break;
                    }
                    }
                }
            else if (d=='t'){
                    while(1){
                    char p=PC.getc();
                    if (p=='f') servo31=1;
                    else if (p=='s') servo32=1;
                    else if (p=='t') servo33=1;
                    else if (p=='F') servo34=1;
                    else if (p=='R'){
                        servo31=0; servo32=0; servo33=0; servo34=0;
                        break;
                    }
                    }
                }
                
                    
            else if (d=='R') {break;}         
                
                
        
}
}
}
}

void LEDgame()
{
    while(Dist() < D)
    {
        levelreset = 0;
        for (col=0; col<4; col++)
        {led = order[row][col]; light(led);} //switches on the respective LEDs according to the order

    while(Dist() < D)
    {
        new_pb1 = pb1; new_pb2 = pb2;
        new_pb3 = pb3; new_pb4 = pb4;
        
    if( ((new_pb1 == 0) && (old_pb1 == 1)) || ((new_pb2 == 0) && (old_pb2 == 1)) || ((new_pb3 == 0) && (old_pb3 == 1)) || ((new_pb4 == 0) && (old_pb4 == 1)) )
    {
        switch(order[row][i])
        {
            case 1:
            {
                if((new_pb1 == 0) && (old_pb1 == 1))
                { myled1 = 1; i++;}
                else {reset(); levelreset = 1; tries++;}
            } break;
            case 2:
            {
                if((new_pb2 == 0) && (old_pb2 == 1))
                { myled2 = 1; i++;}
                else {reset(); levelreset = 1; tries++;}
            } break;
            case 3:
            {
                if((new_pb3 == 0) && (old_pb3 == 1))
                { myled3 = 1; i++;}
                else {reset(); levelreset = 1; tries++;}
            } break;
            case 4:
            {
                if((new_pb4 == 0) && (old_pb4 == 1))
                { myled4 = 1; i++;}
                else {reset(); levelreset = 1; tries++;}
            } break;
        }
        if (levelreset == 1) //do if the level was reset during the game
        {
            //reset level to zero to stop game if number of tries exceeded
            if (tries > 3) {level = 0; reset(); return;}
            else break;
        }
        else if (levelreset == 0) //else increment level counter
            if(i >= 4){level++; wait(2); reset(); return;}
    }
        old_pb1 = new_pb1; old_pb2 = new_pb2;
        old_pb3 = new_pb3; old_pb4 = new_pb4;
    }
    }
}



void reset() //function to turn off LEDs and reset order
{
    myled1 = 0; myled2 = 0; myled3 = 0; myled4 = 0;
    i = 0; wait(1); return;
}

void light(int n) //to turn on LEDs
{
    //sets delay based on level number
    if(level == 1) delay = 1;
    else if (level == 2) delay = 0.75;
    else if (level == 3) delay = 0.50;
    else if (level == 4) delay = 0.25;
    
    //turns LED on for delay seconds before turning off
    if(n == 1) {myled1 = 1; wait(delay); myled1 = 0;}
    else if(n == 2) {myled2 = 1; wait(delay); myled2 = 0;}
    else if(n == 3) {myled3 = 1; wait(delay); myled3 = 0;}
    else if(n == 4) {myled4 = 1; wait(delay); myled4 = 0;}
    return;
}

int Dist() //returns distance
{
    uint8_t dist;
    lcd->cls(); lcd->locate(0,0);
    dist = TOF_sensor.getDistance();
    lcd->printf("Dist=%d", dist);
    return dist;
}

int MAX(int R, int G, int B) //returns max rgb value
{
    int max;
    if (R > G) max = R;
    else max = G;
    if (B > max) max = B;
    return max;
}


