#include "mbed.h"
#include "math.h"
#include "krs.h"
#include "param.h"

#include "finger_joint_motor.h"

#define Num 4

AnalogIn Index(PA_0);
Serial pc(USBTX,USBRX);
//krs master(PC_12,PD_2,PA_7,1250000);
krs master(PA_9,PA_10,PC_7,1250000);
DigitalIn button(USER_BUTTON);
DigitalOut LED(PA_5);

void command_display(){
     pc.printf("\r\n");
     pc.printf("choose mode from 0 to 3\r\n");
     pc.printf("mode 0:Initilizeposition\r\n");
     pc.printf("mode 1:motor test\r\n");
     pc.printf("mode 2:motor angle now\r\n");
     pc.printf("mode 3:finger test\r\n");
     pc.printf("\r\n");
    }

void enter_id(int* id){
    int temp[2]={0};
    for(int i=0;i<2;i++){
    temp[i]=pc.getc()-48;
    pc.printf("%d",temp[i]);
    }
    pc.printf("\r\n");
    *id=temp[0]*10+temp[1];
    pc.printf("%d\r\n",*id);
    }
    
void enter_pos(float* deg){
    int degpart[3]={0};
    pc.printf("degree\r\n");
    pc.printf("- or +\r\n");
    int a=pc.getc()-48;
    if(a==-3){
        a=-1;
        pc.printf("negative direction\r\n");
        }else{
            a=1;
            pc.printf("positive direction\r\n");
            }

    pc.printf("magnitude\r\n");
    for(int i=0;i<3;i++){
        degpart[i]=pc.getc()-48;
        printf("%d",degpart[i]);      
        }
        printf("\r\n");
        *deg=a*(100*degpart[0]+10*degpart[1]+degpart[2]);
    
    pc.printf("%d\r\n",*deg);
    }
    
//void finger_pose(int pose);

int main(){
    printf("hello\r\n");
    float deg=0.0f;
    int id;
    char mode;
    int angle[4]={0};
    float angle_step[4]={0.0f};
    float motor_deg_now[4]={0.0f};
    int step=30;
    
    while(1){
        command_display();
        mode=pc.getc();
        pc.printf("mode %d is selected\r\n",mode-48);
        wait(1.0);
        
        switch(mode){
            case '0': 
            pc.printf("Initilizing...\r\n");
            
            master.setstrech(14,4);
            master.setstrech(7,4);
            master.setstrech(19,4);
            master.setstrech(11,4);
            
            master.setpos(-71,14);//dipの駆動
            wait(1.0);
            master.setpos(-36,7);//pipの駆動
            wait(1.0);
            master.setpos(-18,19);//mpの駆動
            wait(1.0);
            master.setpos(18,11);//abdの駆動
            wait(1.0);
            break;
            
            case '1':
            pc.printf("setting speed\r\n");
            pc.printf("setting strech\r\n");
            pc.printf("id\r\n");
            
            enter_id(&id);
            
            pc.printf("choose strech mode from 1 to 4\r\n");
            int strech=pc.getc()-48;
            master.setstrech(id,strech);
            
            enter_pos(&deg);
            master.setpos(deg,id);
            break;
            
            case '2':
            enter_id(&id);
            master.getpos(id);
            break;
            
            case '3':
            pc.printf("moving finger\r\n");
            motor_angle_calc(10,30,40,30,angle);
            
            for(int i=0;i<4;i++){
                angle_step[i]=(float)(angle[i])/30.0;
                }
            for(int i=0;i<step;i++){
                master.setpos(18+angle_step[3]*(i+1),11);
                master.setpos(-18+angle_step[2]*(i+1),19);
                master.setpos(-36+angle_step[1]*(i+1),7);
                master.setpos(-71+angle_step[0]*(i+1),14);
                }
            
            wait(2.0);
            
            motor_deg_now[0]=master.getpos(14);//dip用モータの現在角度
            wait(1.0);
            motor_deg_now[1]=master.getpos(7);//pip用モータの現在角度
            wait(1.0);
            motor_deg_now[2]=master.getpos(19);//mp用モータの現在角度
            wait(1.0);
            motor_deg_now[3]=master.getpos(11);//abd用モータの現在角度
            wait(1.0);
            
            for(int i=0;i<step;i++){
                master.setpos(motor_deg_now[0]-angle_step[0]*(i+1),14);
                master.setpos(motor_deg_now[1]-angle_step[1]*(i+1),7);
                master.setpos(motor_deg_now[2]-angle_step[2]*(i+1),19);
                master.setpos(motor_deg_now[3]-angle_step[3]*(i+1),11);
                }
            break;
            
            default:
            break;
            }
            
            }
        }
    
