#include "mbed.h"
/**************************************************************/
/*         Déclaration des Sous fonctions                                     */
/**************************************************************/
// initialisations Leds
DigitalOut Led_rouge(LED1,1);
DigitalOut Led_verte(LED2,1);
DigitalOut Led_bleue(LED3,1);
// Initialisation WX200
void ISR_read(); // lecture liaison serie
uint8_t gencrc2(uint8_t *data); // calcul crc NMEA
void lire_luminosite();
void lire_WX200();
DigitalOut myled(PTB22);
DigitalOut CMD_200WX(PTA1,0);
// initialisation de la liaison serie vers le capteur WX200
static UnbufferedSerial capt(PTC4,PTC3,4800);
char c;
char Rx_buffer[100];
char trame[100];
char trame_cpy[100];
volatile bool flag_ISR_read=0;
volatile int index=0;
// variables associees au capteur WX200
static char type[20]; // type de la trame (GPGGA, RMC...)
const char * separators = ","; // separateurs pour une trame NMEA
char i;
size_t len;
uint8_t val_crc;  // valeur du crc calcule a la reception de la trame
// variables associees a une trame de type GPGGA
bool flag_GPGGA=0;
static char horaire[20]; // heure UTC (champ 1)
static char lattitude[20];  // Lattitude (champ 2)
static char hemisphere[2];  // Hemisphere (N/S) (champ 3)
static char longitude[20];  // Longitude (champ 4)
static char dir[2];         // direction (E/W) (champ 5)
static char quality[2];    // GPS quality indicator (0 a 8) (champ 6)
static char nb_satellites[10];  // Number of satellites in use, 0-12 (champ 7)
static char HDOP[10];          // Horizontal dilution of precision (HDOP) (champ 8)
static char altitude[10];      // Altitude relative to mean-sea-level (geoid), meters (to the nearest whole meter) (champ 9)
static char M[2];               // M (champ 10)
static char altitude_cor[10];  // Geoidal separation, meters (to the nearest whole meter). (champ 11)
int n_sat;                      // nombre de satellites

// variables associees a une trame de type WIMDA
bool flag_WIMDA=0;
static char pres_inch[20];   // Barometric pressure, inches of mercury, to the nearest 0.01 inch (champ 1)
static char I[2];            // inches of mercury (champ 2)
static char pres_bar[20];    // Barometric pressure, bars, to the nearest .001 bar(champ 3)
static char B[2];            // B = bars (champ 4)
static char air_temp[10];          // Air temperature, degrees C, to the nearest 0.1 degree C (champ 5)
static char C1[2];               // C = degrees C (champ 6)
static char wat_temp[10];       // Water temperature, degrees C (champ 7) blank with WX200
static char C2[2];              // C = degrees C (champ 8)
static char rel_hum[10];      // Relative humidity, percent, to the nearest 0.1 percent (champ 9)
static char abs_hum[10];      // Absolute humidity, percent (champ 10) blank with WX200
static char dew_point[10];  // Dew point, degrees C, to the nearest 0.1 degree C (champ 11)  blank with WX200
static char C3[2];              // C = degrees C (champ 12)
static char Wind_dir_T[10];  // Wind direction, degrees True, to the nearest 0.1 degree (champ 13)
static char T[2];              // T = True (champ 14)
static char Wind_dir_M[10];  // Wind direction, degrees Magnetic, to the nearest 0.1 degree (champ 15)
static char M2[2];              // M = magnetic (champ 16)
static char Wind_speed_knots[10];  // Wind speed, knots, to the nearest 0.1 knot (champ 17)
static char N[2];              // N = knots (champ 18)
static char Wind_speed_ms[10];  // Wind speed, meters per second, to the nearest 0.1 m/s (champ 19)
static char M3[2];              // M = meters per second(champ 20)
// variables associees a une trame de type GPRMC
static char vitesse[20];
static char cap[20];
static char date[20];
static char magn[20];
static char crc[10];



static char alerte[3];



int main()
{
    printf("lancement programme\n");

    while(true) {
        // lecture luminosite
        printf ("mesure luminosite \n");
        lire_luminosite();
        printf ("lecture WX200 \n");
        lire_WX200();
        printf ("attente 5s.... \n");
        thread_sleep_for (5000);
    }
}    // fin programme



/******* Sous fonctions ***************/
void ISR_read()   // lecture liaison serie
{
    char carac;
    capt.read(&carac, 1);
    if (index==100 || carac=='$') index=0;
    Rx_buffer[index]=carac;
    index++;
    if (carac==0x0a) {
        Rx_buffer[index]=0;
        for (char i=0; i<index+1; i++) trame[i] = Rx_buffer[i];
        index=0;
        flag_ISR_read=1;
    }
}

/************** Lecture Pyranometre ************************/
void lire_luminosite()
{
    DigitalOut Cmd_Pyr(PTA2);
    AnalogIn ain0(A0);
    Cmd_Pyr=1; // on alimente le pyranometre!
    printf("Alimentation du pyranometre, mesures dans 5s... \n");
    thread_sleep_for (5000); // on laisse 5 s pour la mesure
    const float Vcc=3.3;
    float tension= Vcc*ain0.read();
    int lum_Wm=tension*1000+(-400);
    float lum_lux=lum_Wm*683;
    //pc.printf("ain0 :  %1.3f V \n\n",ain0.read());
    //pc.printf("mesure :  %1.3f V \n\n",tension);
    printf("luminosite :  %d W/m^2 \n\n",lum_Wm);
    //pc.printf("luminosite :  %1.0f lux \n\n",lum_lux);
    printf ("coupure du pyranometre \n");
    Cmd_Pyr=0; // on coupe le pyranometre!
}


/************** Lecture Station WX200 ************************/
void lire_WX200()
{
    // autorise departs en interruption liaison serie
    capt.attach(&ISR_read,SerialBase::RxIrq);
    // attente 3 secondes puis alimentation du capteur
    thread_sleep_for (500);
    printf("lecture station meteo WX200 dans 5 s\n");
    printf("Lecture trame GPGGA \n");
    thread_sleep_for (5000); // on laisse 5 s de mesures
    CMD_200WX=1;
    while(flag_GPGGA==0) { // afaire en boucle tant que l'on a pas recu les infos
        // si une trame est recue
        if (flag_ISR_read==1) {
            flag_ISR_read=0;
            //printf("%s",trame); // ligne de test gps
            char* token = strtok(trame,"*"); //on met dans trame_cpy la trame sans crc
            strcpy(trame_cpy,token);
            token = strtok(NULL,"*");   // on copie la valeur du crc recu  dans crc
            strcpy(crc,token);
            // on calcule la valeur du crc dans la trame recue
            val_crc=gencrc2((uint8_t *)trame_cpy);
            uint8_t val_crc2;
            sscanf(crc,"%x",&val_crc2);
            // on teste la validite du crc recu
            if (val_crc!=val_crc2) {
                // printf ("crc error\n");
            } else {
                // traitement de la trame en cas de crc correct
                //  printf ("crc OK\n");
                //printf("trame :%s \n",trame_cpy);
                char* token = strtok((char*)trame_cpy,separators);
                strcpy(type,token);
                if ((strcmp(type,"$GPGGA")==0)&&(flag_GPGGA==0)) { // traitement d'une trame GPGGA
                    printf("trame GPGGA : %s \n",trame);
                    token = strtok(NULL,separators);
                    if (strcmp(token,"")!=0) strcpy(horaire,token);
                    token = strtok(NULL,separators);
                    strcpy(lattitude,token);
                    token = strtok(NULL,separators);
                    strcpy(hemisphere,token);
                    token = strtok(NULL,separators);
                    strcpy(longitude,token);
                    token = strtok(NULL,separators);
                    strcpy(dir,token);
                    token = strtok(NULL,separators);
                    strcpy(quality,token);
                    token = strtok(NULL,separators);
                    strcpy(nb_satellites,token);
                    token = strtok(NULL,separators);
                    strcpy(HDOP,token);
                    token = strtok(NULL,separators);
                    strcpy(altitude,token);
                    token = strtok(NULL,separators);
                    strcpy(M,token);
                    token = strtok(NULL,separators);
                    strcpy(altitude_cor,token);
                    token = strtok(NULL,separators);
                    token = strtok(NULL,separators);
                    if (strcmp(nb_satellites,"")!=0) {
                        n_sat=atoi(nb_satellites); // calcul du nombre de satellites
                    }
                    if (n_sat>3) {
                        flag_GPGGA=1; // on signale la fin d'une lecture correcte GPGGA
                        printf("GPGGA OK\n");
                    }
                } // fin if GPGGA
            } // fin else (traitement trame correcte)
        }//fin if read enable
    } // fin while flags ==0
    while(flag_WIMDA==0) { // afaire en boucle tant que l'on a pas recu les infos
        // si une trame est recue
        printf("Lecture trame WIMDA \n");
        if (flag_ISR_read==1) {
            flag_ISR_read=0;
            //printf("%s",trame); // ligne de test gps
            char* token = strtok(trame,"*"); //on met dans trame_cpy la trame sans crc
            strcpy(trame_cpy,token);
            token = strtok(NULL,"*");   // on copie la valeur du crc recu  dans crc
            strcpy(crc,token);
            // on calcule la valeur du crc dans la trame recue
            val_crc=gencrc2((uint8_t *)trame_cpy);
            uint8_t val_crc2;
            sscanf(crc,"%x",&val_crc2);
            // on teste la validite du crc recu
            if (val_crc!=val_crc2) {
                // printf ("crc error\n");
            } else {
                // traitement de la trame en cas de crc correct
                //printf ("crc OK\n");
                //printf("trame :%s \n",trame_cpy);
                char* token = strtok((char*)trame_cpy,separators);
                strcpy(type,token);
                if ((strcmp(type,"$WIMDA")==0)&&(flag_WIMDA==0)) { // traitement d'une trame WIMDA
                    //capt.detach();
                    printf("trame WIMDA : %s \n",trame);
                    token = strtok(NULL,separators);    // champ1
                    if (strcmp(token,"")!=0)strcpy(pres_inch,token);
                    token = strtok(NULL,separators);    // champ2
                    if (strcmp(token,"")!=0) strcpy(I,token);
                    token = strtok(NULL,separators);    // champ3
                    if (strcmp(token,"")!=0)strcpy(pres_bar,token);
                    token = strtok(NULL,separators);    // champ4
                    if (strcmp(token,"")!=0)strcpy(B,token);
                    token = strtok(NULL,separators);    // champ5
                    if (strcmp(token,"")!=0)strcpy(air_temp,token);
                    token = strtok(NULL,separators);    // champ6
                    strcpy(C1,token);
                    /* token = strtok(NULL,separators);    // champ7
                     if (strcmp(token,"")!=0)strcpy(wat_temp,token);
                     token = strtok(NULL,separators);    // champ8
                     if (strcmp(token,"")!=0)strcpy(C2,token);
                     token = strtok(NULL,separators);    // champ9
                     if (strcmp(token,"")!=0)strcpy(rel_hum,token);
                     token = strtok(NULL,separators);    // champ10
                     if (strcmp(token,"")!=0)strcpy(abs_hum,token);
                     token = strtok(NULL,separators);    // champ11
                     if (strcmp(token,"")!=0)strcpy(dew_point,token);
                     token = strtok(NULL,separators);    // champ12
                     if (strcmp(token,"")!=0)strcpy(C3,token);*/
                    token = strtok(NULL,separators);    // champ13
                    if (strcmp(token,"")!=0)strcpy(Wind_dir_T,token);
                    token = strtok(NULL,separators);    // champ14
                    if (strcmp(token,"")!=0)strcpy(T,token);
                    token = strtok(NULL,separators);    // champ15
                    if (strcmp(token,"")!=0)strcpy(Wind_dir_M,token);
                    token = strtok(NULL,separators);    // champ16
                    if (strcmp(token,"")!=0)strcpy(M2,token);
                    token = strtok(NULL,separators);    // champ17
                    if (strcmp(token,"")!=0)strcpy(Wind_speed_knots,token);
                    token = strtok(NULL,separators);    // champ18
                    if (strcmp(token,"")!=0)strcpy(N,token);
                    token = strtok(NULL,separators);    // champ19
                    if (strcmp(token,"")!=0)strcpy(Wind_speed_ms,token);
                    token = strtok(NULL,separators);    // champ20
                    if (strcmp(token,"")!=0)strcpy(M3,token);
                    if (strcmp(air_temp,"")!=0) flag_WIMDA=1; // on signale la fin d'une lecture correcte WIMDA
                } // fin if WIMDA

            } // fin else (traitement trame correcte)
        }//fin if read enable
    } // fin while flags ==0
    // fin mesures station meteo

    printf("fin d'alimentation station meteo WX200 \n");
    CMD_200WX=0;
    // On affiche les informations GPGGA
    printf("horaire UTC :%s \n", horaire); // heure UTC (champ 1)
    printf("lattitude :%s \n",lattitude);  // Lattitude (champ 2)
    printf("hemisphere :%s \n",hemisphere);  // Hemisphere (N/S) (champ 3)
    printf("longitude:%s \n",longitude);  // Longitude (champ 4)
    printf("dir:%s \n",dir);         // direction (E/W) (champ 5)
    printf("quality:%s \n",quality);    // GPS quality indicator (0 a 8) (champ 6)
    printf("nb_satellites:%s \n",nb_satellites);  // Number of satellites in use, 0-12 (champ 7)
    printf("HDOP:%s \n",HDOP);          // Horizontal dilution of precision (HDOP) (champ 8)
    printf("altitude:%s \n",altitude);      // Altitude relative to mean-sea-level (geoid), meters (to the nearest whole meter) (champ 9)
    printf("unit :%s \n",M);
    printf("altitude_cor:%s \n",altitude_cor);  // Geoidal separation, meters (to the nearest whole meter). (champ 10)
    // On affiche les informations WIMDA
    printf("Barometric Pressure :%s %s \n", pres_inch,I); // pression inch + unite (champs 1 et 2)
    printf("Barometric Pressure :%s %s \n", pres_bar,B); // pression bars + unite (champs 3 et 4)
    printf("Air Temperature:%s %s\n", air_temp,C1); // temperature de l'air + unite (champs 5 et 6)
    //printf("Water Temperature:%s %s\n", wat_temp,C2); // temperature de l'air + unite (champs 7 et 8)
    //printf("Relative humidity :%s \n", rel_hum); // humidite relative (champs 9)
    //printf("Absolute humidity :%s \n", abs_hum); // humidite relative (champs 10)
    //printf("Dew Point :%s %s\n", dew_point,C3); // point de rosee + unite (champs 11 et 12)
    printf("Wind direction :%s %s\n", Wind_dir_T,T); // direction du vent en degres vrais + unite (champs 13 et 14)
    printf("Wind direction magne :%s %s\n", Wind_dir_M,M2); // direction du vent en degres vrais + unite (champs 15 et 16)
    printf("Wind speed :%s %s\n", Wind_speed_knots,N); // vitesse du vent en noeuds + unite (champs 17 et 18)
    printf("Wind speed :%s %s\n", Wind_speed_ms,M3); // vitesse du vent en m/s + unite (champs 17 et 18)

}



/************** Calcul CRC          ************************/
uint8_t gencrc2(uint8_t *data)   // calcul crc NMEA
{
    uint8_t crc;
    crc=data[1];
    char i=2;
    while (data[i]!=0) {
        crc = crc^data[i];
        i++;
    }
    return crc;
}