/* #############################################################################
**    Archivo        : main.c
**    Proyecto       : STM32F103C8_Hola_Mundo
**    Procesador     : STM32F103C8T6
**    Plataforma     : Blue Pill
**    Herramienta    : Mbed
**    Compilador     : Mbed Online C Compiler
**    Version        : Mbed-OS 5.15.0
**    Fecha/Hora     : 18-12-2019, 11:48, # CodeGen: 0
**    Descripción    :
**         Este proyecto muestra la configuración y uso de la Terminal Serial
**         utilizando las secuencias de ESCape
**         This module contains user's application code.
**   Componentes     : Serial, etc .
**   Configuraciones : Se puede seleccionar entre diferentes velocidades de 
**                     transmisión
**   Autores         :
**         ATEAM Development Group:
**          - Antulio Morgado Valle
**
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 20/10/2019
**                    Adición de secuencias de ESCape
**                    27/09/2010 
**                    Ejemplo del Hola Mundo
**
** ###########################################################################*/
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/
#include "stm32f103c8t6.h"
#include "mbed.h"
#include "Serial.h"
#include "stdio.h"
#include <limits.h>
#include "wchar.h"
/*
:...............................................................................
:  Definiciones
:...............................................................................
*/
#define LED_ON          0           // Estado para el Led Encendido
#define LED_OFF         1           // Estado para el Led Apagado
#define BUZZ_ON         1           // Estado para Buzzer Encendido
#define BUZZ_OFF        0           // Estado para Buzzer Apagado
#define ON              0           // Estado para boton presionado
#define OFF             1           // Estado para boton sin presionar
#define HOLD            2           // Estado para boton mantenido
#define RELEASE         3           // Estado para boton liberado
#define FALSE           0           // Estado FALSO
#define TRUE            1           // Estado VERDADERO
#define BAUD_RATE       115200      // Velocidad de Transmisión (Bauds)
                                    // Velocidades Permitidas:
                                    // 300, 600, 1200, 2400, 4800, 9600,
                                    // 14400, 19600, 28800, 38400, 57600
                                    // 115200, 230400
/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/

// *****    Host PC Terminal Communication channels
Serial      terminal (PA_2, PA_3);          // Tx2, Rx2 - Terminal Serial (TTL Level) (Default Rate: 9600)
//Serial      terminal(USBTX, USBRX,115200);  // Tx, Rx, Baud Rate - Terminal Serial por USB @ 115,200 Bauds
//Serial      terminal(PA_9, PA_10);          // Tx, Rx  Using MAX3232
// *****    Bluetooth to Host Cell Phone Communication channels
//Serial      Bluetooth   (PB_10, PB_11); // Inicializa la Comunicación Serial UART_3 sobre Bluetooth (Tx, Rx)
//DigitalOut  Key_pin     (PB_1,HIGH);    // Inicializa el KEY pin o STATE pin (AT Commnands)
/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/
uint8_t  v_ch;
uint16_t v_uni;
uint16_t v_wchar;
/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
void Setup(void);   // Función que inicializa la Tarjeta

/* END definitions */ 
/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/
int main()          
{                   // Inicialización de variables, puertos e interrupciones
 Setup();  
 terminal.printf ("\tInstituto Politecnico Nacional\n\r");
 terminal.printf ("ESCUELA SUPERIOR DE INGENIERIA MECANICA Y ELECTRICA\n\r");
 printf ("\vHola Mundo!\r");
 printf ("\v\t\vH\ne\nl\nl\no\n \nW\no\nr\nl\nd\n!\r");
 printf ("\n\nPresiona cualquier tecla para continuar...");    
 char opcion = terminal.getc();
     
 while (TRUE)                // El Lazo del Programa principal está aquí !!!
 {          // La secuencia de ESCape puede iniciar con \e ó \033 ó \x1B 
    printf("\n\r\v\tHola \033[1;37;42mESIME\x1B[0m - \e[1;37;41mIPN\033[0m!!!\n\r\v");
    printf ("\033[1;31mEste es un texto rojo.\n\r\033[0m");
    printf ("\x1B[1;32mEste es un texto verde.\n\r\x1B[0m");
    printf ("\e[1;34mEste es un texto azul.\n\r\e[0m");     
//    printf ("\v\tHecho en \033[1;32mMe\033[0mxi\033[1;31mco.\n\r\v\v\033[0m");
    printf ("\v\tHecho en \e[1;32mMe\e[0mxi\e[1;31mco.\e[0m\n\r\v\v\e[0m");
    terminal.printf("\r\t  \e[1m\e[7mby ATEAM R&D\e]0m");   
    printf ("\n\r Pulse cualquier tecla para continuar!\r");   
    opcion = terminal.getc();
    terminal.putc(opcion);
    uint8_t v_attr;
    uint8_t v_bg;
    uint8_t v_fg;
    printf("\n\v\t\t\"ATRIBUTOS DE COLORES\"\r\n");    
    for (v_attr=0;v_attr<2;v_attr++)
    {
        for (v_bg=30;v_bg<38;v_bg++)
        { 
            for (v_fg=40;v_fg<48;v_fg++)
            {
                printf ("\e[%d;%d;%dm%d,%d,%d\e[0m ",v_attr,v_bg,v_fg,v_attr,v_bg,v_fg);
            }
            printf("\r\n");
        }   
    }

    terminal.printf("\e[0m\r\n"); 
    terminal.printf("\n\a\f\e[7;5;1mBlinking\e[0m\r\n");     
    printf ("\n\nPresiona cualquier tecla para continuar...");    
    char opcion = terminal.getc();
    terminal.printf(" =) \e[2J");      // Clear Screen     
    printf("\r\n");

        /* Imprime los caracteres ASCII */
    for (v_ch = 0; v_ch < UCHAR_MAX; v_ch++)
    {
        /* v_ch == ASCII */
        printf("\e[1;37;42mHex:\e[1;33;42m %02X \e[1;37;46mASCII:\e[1;33;46m%3d \e[1;37;47mCaracter:\e[1;33;44m %c \033[0m\r\n", v_ch, v_ch, v_ch);
        wait(0.5);
    }

    terminal.printf("\a\f\n\r");      //\e[033c
        
        /* Imprime los caracteres Unicode */
//    v_wchar_t star = 0x2605;
//    wprintf(L"%c\n", star);
/*
    for (v_uni = 0400; v_uni < 2000; v_uni++)
    {
        wprintf(L"%c\n", v_uni);
        for (v_uni = 0; v_uni < UCHAR_MAX; v_uni++)
        v_uni == Unicode;
//        printf("%c ==> \\%u\n\r", v_uni, v_uni);
//        printf ("\e[1;37;41mCaracter: %c Unicode %d ===> \e[1;33;41m\\%lc \033[0m\n\r",v_uni, v_uni, v_uni );
//        wait(0.5);
//    }
*/    
 }
}
/* END main */

/*
................................................................................
:  Rutinas de los Vectores de Interrupción
................................................................................
*/
 
/* END Events */ 
/*
________________________________________________________________________________
|
|  Funciones Prototipo
|_______________________________________________________________________________
*/
                // Las Funciones Prototipo van aquí !
void Setup()
{
  confSysClock();     // Configure system clock (72MHz HSE clock, 48MHz USB clock)
  terminal.baud(BAUD_RATE);     // Se configura la velocidad de transmisión 
  terminal.printf("System is Wake Up!.\n\r"); // e inicia la comunicación serial.
}                                             // con la Terminal (PC)

/* END routines */ 

/* END program */                

/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
********************************************************************************
*+
*+                  D O C U M E N T A C I Ó N
*+
********************************************************************************
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|
|                  La documentación va aquí!:
|
|------------------------------------------------------------------------------- 
|                   IDENTIFICADORES
|------------------------------------------------------------------------------- 
|
|  prefijo      signifcado              uso                  
|   v_          variable  (var)         v_nombre_variable   
|   c_          constante (const)       c_nombre_constante
|   i_          indice    (index)       i_nombre_indice 
|   p_          apuntador (pointer)     p_nombre_apuntador
|   l_          etiqueta  (label)       l_nombre_etiqueta
|   f_          función   (function)    f_nombre_funcion
|      
|-------------------------------------------------------------------------------      
|                   CONEXIÓN A LA TERMINAL SERIAL
|------------------------------------------------------------------------------- 
| 
|   Los Transeptores recomedados para se pueden conectar a los siguientes pines
|   de las UART's que posee la Bluepill por medio del siguiente conexionado.
| 
|   UART1   UART2   UART3      CABLE        CP2102  PL2303  CH340G  FT232RL  
|   PA_9    PA_2    PB_10   Tx  ------> Rx    3       2       2        3 
|   PA_10   PA_3    PB_11   Rx  <------ Tx    4       3       3        2
|                           3V  ------  3V    5       5       4        1
|                           GND ------  GND   2       1       1        4
|
|-------------------------------------------------------------------------------
|
................................................................................ 
:    
:               S E C U E N C I A S     D E      E S C A P E
:
................................................................................
|
|
|                SECUENCIAS DE ESCAPE EN "C" PARA LA TERMINAL SERIAL
|
| SECUENCIA         VALOR                       DESCRIPCIÓN
|
|   \n              Nueva línea (new line). El cursor pasa a la primera posición
|                                           de la línea siguiente 
|   \r              Retorno de carro (carriage return). El cursor pasa a la 
|                                           primera posición de la línea donde 
|                                           nos encontremos.
|   \t              Tabulador (tab). El cursor pasa a la siguiente posición de 
|                                           tabulación.
|   \a              Alerta (bell). Crea un aviso bien de forma visible o bien 
|                                           mediante sonido.
|   \b              Espacio atrás (backspace). Hace retroceder el cursor una 
|                                           posición a la izquierda.
|   \f              Alimentación de página (form feed). Crea una nueva página.
|   \v              Tabulación vertical (vertical tab).
|   \0              Caracter Nulo (null).
|   \'              Apóstrofo o comilla simple.
|   \”              Muestra la comilla doble.
|   \?              Muestra un interrogante.
|   \\              Muestra la barra invertida.
|   \número_octal   Muestra el carácter ASCII correspondiente según el número 
|                                           octal que se haya especificado.
|   \xnúmero_hexadecimal    Muestra el carácter ASCII correspondiente según el 
|                                           número hexadecimal que se haya 
|                                           especificado.
|   \unnnn          Muestra Caracter en código unicode.
|   \unnnnnnnn      Muestra varios caracteres en código unicode.
|
|  \e[ es para el inicio de una secuencia de caracteres no imprimibles
|  \e] es para el final de una secuencia de caracteres no imprimibles
|
| Consejo: para memorizarlo, primero puede agregar \e[\e] y luego poner su 
| código ANSI entre ellos: 
| – \e[start-ANSI-code\e]
| – \e[end-ANSI-code\e]
|
|
|      SECUENCIAS DE ESCAPE PARA MODIFICAR LOS COLORES DE LA TERMINAL SERIAL
|
|  tipo de secuencia de color:
|
|    3/4 bit
|    8 bits
|    24 bits
|
| Antes de sumergirte en estos colores, debes conocer 4 modos con estos códigos:
|
| 1. modo de color  (lighting)
|
| Modifica el estilo del color, NO el texto. 
| Por ejemplo, haz que el color sea más claro o más oscuro.
|
|    0 reinicio
|    1; Más ligero de lo normal
|    2; más oscuro de lo normal
|
| Este modo no es compatible ampliamente. Es totalmente compatible con Gnome-Terminal.
|
| 2. modo de texto
|
| Este modo es para modificar el estilo del texto NO el color.
|
|   3; itálico
|   4; subrayar
|   5; parpadeando (lento)
|   6; parpadeando (rápido) 
|   7; marcha atrás
|   8; esconder
|   9; tachar
|
| y son casi compatibles.
| Por ejemplo, KDE-Konsole admite 5; pero Gnome-Terminal no lo hace y 
| Gnome es compatible con 8; pero KDE no.
|
| 3. modo de primer plano (Foreground)
| 
| Este modo es para colorear el primer plano.
|
| 4. modo de fondo  (Background)
|
| Este modo es para colorear el fondo. 
|
|
|                SECUENCIAS DE ESCAPE ECMA-48
|
| ECMA-48 Pone modo Gráfico
|       La secuencia ECMA-48 SGR  ESC [ <parámetros> m establece los atributos de
|       la pantalla.  Se pueden poner varios atributos en la misma secuencia.
|
|     param   Resultado
|       0     restablece todos los atributos a sus valores predeterminados
|       1     pone negrillas
|       2     pone medio brillo (simulado con color en una pantalla a color)
|       4     pone subrayado (simulado con color en una pantalla a color)
|             (los colores para simular disminución o subrayado se ponen con
|             ESC ] ...)
|       5     pone intermitencia
|       7     pone vídeo inverso
|       10    restaura asociación seleccionada, indicador de control de
|             pantalla y cambia el indicador meta
|       11    selecciona no asociación, pone indicador de control de
|             pantalla, restaura indicador de cambio meta
|       12    selecciona no asociación, pone indicador de control de
|             pantalla, pone indicador de cambio meta (que hace que el bit
|             más alto de un byte cambie antes de que se haga la traducción
|             de la tabla de asociación.)
|       21    pone intensidad normal (esto no es compatible con ECMA-48)
|
|       22    pone intensidad normal
|       24    quita subrayado
|       25    quita intermitencia
|       27    quita vídeo inverso
|       30    pone negro
|       31    pone rojo
|       32    pone verde
|       33    pone marrón
|       34    pone azul
|       35    pone rosa
|       36    pone celeste
|       37    pone blanco
|       38    pone subrayado, color predeterminado
|       39    quita subrayado, pone color predeterminado
|       40    pone negro de fondo
|       41    pone rojo de fondo
|       42    pone verde de fondo
|       43    pone marrón de fondo
|       44    pone azul de fondo
|       45    pone rosa de fondo
|       46    pone celeste de fondo
|       47    pone blanco de fondo
|       49    pone el color de fondo predeterminado
|
| Tambien consultar:
| https://en.wikipedia.org/wiki/ANSI_escape_code
| https://es.wikipedia.org/wiki/C%C3%B3digo_escape_ANSI
| http://www.braun-home.net/michael/info/misc/VT100_commands.htm
| https://www.enmimaquinafunciona.com/pregunta/170760/secuencias-de-escape-terminales-en-la-pantalla-gnu
| http://softwarelivre.org/terceiro/blog/a-visual-cheat-sheet-for-ansi-color-codes
| https://unicode-table.com/es/alphabets/spanish/
+-------------------------------------------------------------------------------
|
|                               EJERCICIO
|
| 1.-   Crear la función: 
|       void Caratula()     y
| 2.-   Utilizando printf y las secuencias de escape, crear una Carátula de 
|       presentación con los datos personales y escolares para ser ejecutada al 
|       inicio del programa. 
|
|                               EXAMEN
|
| 1.-   Crear la Rutina para desplegar los caracteres UNICODE correspondientes 
|       al idioma Español  
|
+-------------------------------------------------------------------------------
|
|                     T H E     A N T U L I U S   T E A M
|  Research, Development, Systems Equipment, Support & Spare Parts    I n c.
|                (C) Copyright 1989-2014, All rigths Reserved
|
| This program is licensed under rules of
| THE BEANERS TECHNOLOGIES PROYECT
+-------------------------------------------------------------------------------
*/

/* END documentation */ 

/* END Mbed */