/* ###########################################################################
**    Archivo        : main.c
**    Proyecto       : STM32-103C8_Adivina
**    Procesador     : STM32F103C8
**    Plataforma     : Blue Pill
**    Herramienta    : Mbed
**    Compilador     : Mbed Online C Compiler
**    Version        : Mbed-OS 5.15.0
**    Fecha/Hora     : 18-12-2019, 11:48, # CodeG
**    Descripción    :
**         Este proyecto muestra la configuración y uso de la Terminal Serial
**         para intercurar con el usuar a traves del juego de "Adivina el Número" 
**         This module contains user's application code.
**   Componentes     : Timer, etc .
**   Configuraciones : Se puede seleccionar entre diferentes velocodades de 
**                     transmisión
**   Autores         :
**         ATEAM Development Group:
**          - Antulio Morgado Valle
**
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 20/10/2019
**                    Ejemplpo del Hola Mundo
**                    27/09/2010 
**                    
**
** ###########################################################################*/
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/

#include "stm32f103c8t6.h"
#include "mbed.h"
#include "Serial.h"
#include "stdio.h"
/*
:...............................................................................
:  Definiciones
:...............................................................................
*/
#define LED_Type        0           // Tipo de LED RGB: 0=Cátodo Común, 1=Ánodo Común
#define on              0           // Estado para boton presionado
#define off             1           // Estado para boton sin presionar
#define hold            2           // Estado para boton mantenido
#define release         3           // Estado para boton liberado
#define FALSE           0           // Estado FALSO
#define TRUE            1           // Estado VERDADERO
#define Buzz_Off        0           // Estado del Buzzer Apagado
#define Buzz_On         1           // Estado del Buzzer Encendido
#define Baud_Rate       115200      // Velocidad de Transmisión (Bauds)
                                    // Velocidades Permitidas:
                                    // 300, 600, 1200, 2400, 4800, 9600,
                                    // 14400, 19600, 28800, 38400, 57600
                                    // 115200, 230400
#if Display_Type == 0               // Si el Led RGB es Cátodo Común
#define led_on          1           // Estado para el Led encendido
#define led_off         0           // Estado para el Led encendido
#endif

#if Display_Type == 1               // Si el Led RGB es Ánodo Común
#define led_on          0           // Estado para el Led encendido
#define led_off         1           // Estado para el Led encendido
#endif
/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/
DigitalOut  led_monitor(LED1);      // Inicializa el LED Monitor (Interno)
DigitalOut  led_azul(PB_0);         // Inicializa el PWM1 (PB0_TIM3_CH3) Led AZUL
DigitalOut  led_verde(PA_7);        // Inicializa el PWM2 (PA7_TIM3_CH2) Led VERDE
DigitalOut  led_rojo(PA_6);         // Inicializa el PWM3 (PA6_TIM3_CH1) Led ROJO
PwmOut      buzzer(PB_1);           // PB1_TIM3_CH4N
// *****    Host PC Terminal Communication channels
Serial      terminal (PA_2, PA_3);          // Inicializa la comunicación serial a la PC (Tx,Rx)
//Serial      terminal(USBTX, USBRX,115200);// Tx, Rx  Baud Rate - Terminal Serial por USB @ 115,200 Bauds

/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/
uint8_t  Seleccion;                 // Seleccion de opción para el menú
/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
void setup(void);
void buzzer_test(void);
void clear_screen(void);
/* END definitions */ 

/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/
int main()          
{                   // Inicialización de variables, puertos e interrupciones
  confSysClock();     // Configure system clock (72MHz HSE clock, 48MHz USB clock)
  setup();            // Inicialización del sistema
  terminal.printf ("ADIVINA\n\r");
  led_rojo  = led_off;
  led_verde = led_off;
  led_azul  = led_off; 
  terminal.printf(" System is Wake Up!.\n\r");    // e inicia la  comunicación serial
  terminal.printf ("\t\e[1;37;41mInstituto Politecnico Nacional\e[0m\n\r");
  terminal.printf ("\e[1;37;42mESCUELA SUPERIOR DE INGENIERIA MECANICA Y ELECTRICA\e[0m\n\r\v");
  terminal.printf ("\t\e[1;34;40mAdivina \e[1;37;40mel \e[1;32;40mNumero \e[1;33;40mSecreto \e[0m\n\r\v\v\e[0m");
  terminal.printf("Pulse Cualquier Tecla para continuar..."); // Pausa 
  Seleccion=getchar();
  while(TRUE) 
    {   
Inicio:     clear_screen();                 // Limpia la Pantalla de la Terminal
            terminal.printf(" DIGITE UN NUMERO SECRETO DE 0 A 9 \r\n");
            char secreto = terminal.getc();
            led_rojo  = led_on ;
            led_verde = led_on ;
            led_azul  = led_on ;
            clear_screen();                 // Limpia la Pantalla de la Terminal
Intenta:   terminal.printf(" ADIVINA EL NUMERO: \r\n");
            char respuesta = terminal.getc();
            if( secreto < respuesta  ) 
            {
                terminal.printf(" Es mas Bajo  \r\n");
                led_rojo  = led_on ;
                led_verde = led_off;
                led_azul  = led_off;             
                goto Intenta;
            }
            if( secreto > respuesta  ) 
            {
                terminal.printf(" Es mas Alto  \r\n");
                led_rojo  = led_off;
                led_verde = led_off;
                led_azul  = led_on ;
                goto Intenta;
            }
            if( secreto == respuesta ) 
            {
                terminal.printf(" CORRECTO!, Es igual a: %c \r\n",secreto);
                led_rojo  = led_off;
                led_verde = led_on ;
                led_azul  = led_off;
                wait(1.0);
                led_rojo  = led_off;
                led_verde = led_off;
                led_azul  = led_off;
                wait(1.0);
                led_rojo  = led_off;
                led_verde = led_on ;
                led_azul  = led_off;
                wait(1.0);
                terminal.printf(" Eres un Genio !!!  \r\n");
                wait(1.0);
                led_rojo  = led_on ;
                led_verde = led_off;
                led_azul  = led_on ;
                wait(1.0);
                led_rojo  = led_on ;
                led_verde = led_on ;
                led_azul  = led_off;
                wait(1.0);
                led_rojo  = led_off;
                led_verde = led_on ;
                led_azul  = led_on ;
                wait(1.0);
                led_rojo  = led_on ;
                led_verde = led_on ;
                led_azul  = led_on ;
            }
        terminal.printf(" Quieres intentarlo de nuevo?  \r\n");
        terminal.printf(" 0 = No \r\n 1 = Si  \r\n");
            char opcion = terminal.getc();
            if( opcion == '1' ) goto Inicio;
            else if( opcion == '0' )
            {
                led_rojo  = led_off;
                led_verde = led_off;
                led_azul  = led_off;
                terminal.printf(" Eso es todo Amigos!  \r\n");
                break;
            }
        }
}

/* END main */

/*
................................................................................
:  Rutinas de los Vectores de Interrupción
................................................................................
*/
 
/* END Events */ 
/*
________________________________________________________________________________
|
|  Funciones Prototipo
|_______________________________________________________________________________
*/
                // Las Funciones Prototipo van aquí !
void setup()
{   
  terminal.baud(Baud_Rate);         // Se configura la velocidad de transmisión  
  terminal.printf("\r System is Wake Up!.\n\r"); //e inicia la comunicación a la Terminal.
  buzzer_test();
  clear_screen();
}
              
void buzzer_test()             // Software Blinking routine for LED 
{
    /* Prueba del Buzzer */
    terminal.printf("Testing Buzzer... \n\r");
    buzzer = Buzz_On;
    wait_ms(750);
    buzzer = Buzz_Off;
    wait_ms(125);
    buzzer = Buzz_On;
    wait_ms(250);
    buzzer = Buzz_Off;
    wait_ms(125);
    buzzer = Buzz_On;
    wait_ms(500);
    buzzer = Buzz_Off;
    terminal.printf("Buzzer OK ! \n\r");
}

void clear_screen() 
{
//ANSI Terminal Commands
    terminal.printf("\x1B[2J");
    terminal.printf("\x1B[H");
}

/* END routines */   
 
/* END program */                
/*+-----------------------------------------------------------------------------       
*+ La documentación va aquí!:
*+-----------------------------------------------------------------------------       
*+  Conexión al Led RGB:
*+------------------------------------------------------------------------------
*+ 
*+  Los leds se pueden conectar a cualquier pin que se declare como DigitalOut. 
*+  El dispositivo puede drenar hasta 20ma por todas sus salidas a un voltaje de 
*+  3.3V, pero se recomienda no exceder de 1mA por salida.
*+  Esto se logra poniendo una resistencia limitadora de mínimo 330 Ohms.
*+   
*+ 
*+            PIN (Digital Out)  
*+
*+     Led ROJO      Led VERDE   Led AZUL
*+
*+       R       GND      G        B
*+       O        O       O        O
*+       |        |       |        |
*+       |        |       |        |
*+       /        |       /        /
*+       \   1K   |       \   2K   \   2.2K  
*+       /        |       /        /
*+       \        |       \        \         UTILIZANDO LED RGB DE CÁTODO COMÚN
*+       |        |       |        |
*+       |        |       |        |
*+    ___|___     |    ___|___  ___|___     
*+    \      /    |    \      / \      /
*+     \    /     |     \    /   \    /
*+      \  /      |      \  /     \  /
*+     __\/__     |     __\/__   __\/__
*+       |        |       |        |
**       |        |       |        |
*+       |________|_______|________|   
*+
*+      
*+      
*+            PIN (Digital Out)  
*+
*+     Led ROJO      Led VERDE   Led AZUL
*+       
*+       R       VCC      G        B
*+       O        O       O        O
*+       |        |       |        |
*+       |        |       |        |
*+       /        |       /        /
*+       \   2K   |       \   1K   \   1K  
*+       /        |       /        /
*+       \        |       \        \         UTILIZANDO LED RGB DE ÁNODO COMÚN
*+       |        |       |        |
*+       |        |       |        |
*+    ___|___     |    ___|___  ___|___
*+      /\        |      /\       /\
*+     /  \       |     /  \     /  \
*+    /    \      |    /    \   /    \
*+   /______\     |   /______\ /______\
*+       |        |       |        |
**       |        |       |        |
*+       |________|_______|________|   
*+
*+    
*+
*+------------------------------------------------------------------------------
*+ Descripción del Coexionado del Buzzer
*+------------------------------------------------------------------------------
*+
*+                  150
*+  PWM Pin  -----/\/\/\/-------|
*+                              | 
*+                              |  +
*+                              |  
*+                            ( o ) BUZZER
*+                              |
*+                              |
*+                              |
*+                              |
*+                            -----
*+                             ---
*+                              -
*+
*+------------------------------------------------------------------------------
*/
/* END documentation */ 
/*
+--------------------------------------------------------------------------------
|                               EJERCICIO
|
| 1.-   Este programa tambien acepta letras o caracteres?
| 2.-   Modificar este programa para: 
|       a) Que solo acepte números
|       b) Agregar un contador de Número de Intentos 
|       
+--------------------------------------------------------------------------------
|
|                               EXAMEN
|
| 1.-  Modificar el programa para que despliegue el número de intentos para 
|      adivinar el número secreto.
| 2.-  Modificar el programa para haga eco con la respuesta que le introducimos.
| 3.-  Bloquear el programa despues de cierto número de intentos
| 4.-  Modificar el programa para que el número secreto sea generado aleatoriamente.
|      a) Generar un Número Pseudo Aleatorio Mediante el Ticker
|      b) Utilizando la función RANDOMIZE
| Suerte!
+--------------------------------------------------------------------------------
|
|                     T H E     A N T U L I U S   T E A M
|  Research, Development, Systems Equipment, Support & Spare Parts    I n c.
|                (C) Copyright 1989-2014, All rigths Reserved
|
| This program is licensed under rules of
| THE BEANERS TECHNOLOGIES PROYECT
+-------------------------------------------------------------------------------
*/
/* END Mbed */ 