#include "mbed.h"
#include "PinNames.h"
#include "stm32_janzaldo.h"
/*
:...............................................................................
:  Definiciones  by Jorge Anzaldo 
:...............................................................................
*/
/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/

DigitalOut  led_monitor(LED1);      // Inicializa el LED Monitor
DigitalOut  led_testigo(PB_1);      // Inicializa el LED Testigo

BusOut Salida(PA_8,PA_9,PA_10,PA_11, PB_4, PB_5, PB_6, PB_7); // Identificando LED's

Serial      terminal(PA_2, PA_3);  // Inicializa la Comunicación Serial a la PC

/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/
int tiempo = 100;

/* FIN Definiciones*/  
/*
+-------------------------------------------------------------------------------
|  Desarrollo de metodos / funciones miembro de las clases
+-------------------------------------------------------------------------------
*/
Stm32::Stm32(void){
    terminal.baud(115200);    
    led_monitor=0;   
    terminal.printf("\r\n\t\t >>> Terminal Conectada <<< \r\n");  
}
void Stm32::Lp(void){
    printf("\033[2J"); // limpiar   
}
void Stm32::Mensaje(const char *txt){
    terminal.printf("\r\n %s \r\n",txt); 
}
void Stm32::Pausa(void){
    terminal.printf("\r\n Oprime cualquier tecla para continuar \r\n"); 
    getchar();
}
void Stm32::Testigo(bool status){
    if(status){ led_testigo=1;}
    else{led_testigo=0;}}
void Stm32::Intermitente(int veces){
    int i=0;
    while(i<veces){
        Testigo(true);
        wait_ms(200);
        Testigo(false);
        wait_ms(200);
        i++;
    }
}
void Stm32::Leer(const char *txt, int &valor){
    terminal.printf("\r\n %s ",txt); 
    terminal.scanf("%d",&valor);
}
void Stm32::Ver(const char *txt, int valor){
    terminal.printf("\r\n %s %d",txt,valor); 
}
void Stm32T::Encender(int v){
    Salida[v]=1; 
    wait_ms(tiempo);  
}
void Stm32T::Apagar(int v){
    Salida[v]=0;
}
void Stm32T::Ascendente(void){
    for(int i=0;i<8;i++){
        Encender(i);
        Apagar(i);
    }
}
void Stm32T::Descendente(void){
    for(int i=7;i>=0;i--){
        Encender(i);
        Apagar(i);
    }    
}
void Stm32T::Afuera(void){
    for(int i=3,j=4;i>=0;i--,j++){
        Encender(i);
        Encender(j);
        wait_ms(tiempo);
    }
    Salida=0;
  
}
void Stm32T::Adentro(void){
    for(int i=0,j=7;i<4;i++,j--){
        Encender(i);
        Encender(j);
        wait_ms(tiempo);
    }
    Salida=0;
    
}
/* FIN */  