#include "mbed.h"
#include <string>

using namespace std;

Ticker timer;

Serial controller_uart(PA_0,PA_1,19200);
Serial ems_uart(PA_9,PB_7,19200);
Serial usb_uart(USBTX,USBRX,9600);

DigitalOut EMS(PA_10);

DigitalIn ZONE(PC_5);
DigitalIn PS1(PC_12);
DigitalIn PS2(PA_5);
DigitalIn TS1(PC_11);
DigitalIn TS2(PC_10);
DigitalIn TS3(PC_6);
DigitalIn TS4(PC_8);

volatile int cnt = 0;
volatile int con_status = 0;
volatile unsigned char tx_data[11] = { 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x00 };
volatile unsigned char dualshock_data[10] = { 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80 };
volatile unsigned char dualshock_data_number = 0;
volatile unsigned char dualshock_cmd_getflag = 0;

//遠隔非常停止受信処理
void recieve_ems(){
    uint8_t rxdata = ems_uart.getc();
    
    if(rxdata == 0xEE){
        cnt = 50;
    }
}

void time() {
    if(dualshock_cmd_getflag & 0x02) {
        dualshock_cmd_getflag = 0;
        
        tx_data[1] = 0x00;
        tx_data[2] = 0x00;
        tx_data[3] = 0x00;
        tx_data[4] = 0x80;
        tx_data[5] = 0x80;
        tx_data[6] = 0x80;
        tx_data[7] = 0x80;
        
        dualshock_data[1] = 0x00;
        dualshock_data[2] = 0x00;
        dualshock_data[3] = 0x00;
        dualshock_data[4] = 0x80;
        dualshock_data[5] = 0x80;
        dualshock_data[6] = 0x80;
        dualshock_data[7] = 0x80;
        
        con_status = 0;
    }else
        dualshock_cmd_getflag |= 0x02;
}

//JETSON送信処理
void send_tx_data(){
    usb_uart.putc('C');
    for(int i = 1; i < 9; i++){
        usb_uart.putc(tx_data[i]);
    }
    usb_uart.putc('E');
}

//コントローラー受信処理
void read_controller_data() {
    unsigned char rxdata;
    
    rxdata = controller_uart.getc();
    
    if (dualshock_data_number == 0 && rxdata == 'S')
        dualshock_data_number++;
    else if (dualshock_data_number >= 1 && dualshock_data_number <= 7) {
        if (dualshock_data_number <= 3)
            dualshock_data[dualshock_data_number] = ~rxdata;
        else
            dualshock_data[dualshock_data_number] = rxdata;
        dualshock_data_number++;
    }
    else if (dualshock_data_number == 8 && rxdata == 'E') {
        dualshock_cmd_getflag = 0x01;
        for(int i = 0; i < 8; i++){
            tx_data[i] = dualshock_data[i];
        }
        con_status = 1;
        dualshock_data_number = 0;
    }
}

//main
int main(){
    int c = 9;
    
    ZONE.mode(PullUp);
    PS1.mode(PullUp);
    PS2.mode(PullUp);
    TS1.mode(PullUp);
    TS2.mode(PullUp);
    TS3.mode(PullUp);
    TS4.mode(PullUp);
    
    timer.attach_us(&time, 100000);
    
    controller_uart.attach(&read_controller_data, Serial::RxIrq); //受信割り込み
    ems_uart.attach(&recieve_ems, Serial::RxIrq);
    
    while(1){
        if(cnt){
            EMS = 0;
            cnt--;
        }else{
            EMS = 1;
        }
        
        if(con_status){
            tx_data[8] |= 0x80;
        }
        if(!ZONE){
            tx_data[8] |= 0x40;
        }
        if(!PS1){
            tx_data[8] |= 0x20;
        }
        if(!PS2){
            tx_data[8] |= 0x10;
        }
        if(!TS1){
            tx_data[8] |= 0x08;
        }
        if(!TS2){
            tx_data[8] |= 0x04;
        }
        if(!TS3){
            tx_data[8] |= 0x02;
        }
        if(!TS4){
            tx_data[8] |= 0x01;
        }
        
        if(!cnt){
            send_tx_data();
            tx_data[8] = 0x00;
            c = 9;
        }else{
            c--;
        }
        
        wait_ms(10);
    }
}