/* SAA1064 4 Digit Library
 * Copyright (c) 2015 Marcel (mc-b) Bernet
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef _SAA1064_H
#define _SAA1064_H

//Address Defines for SAA1064
#define SAA1064_SA0 0x70
#define SAA1064_SA1 0x72
#define SAA1064_SA2 0x74
#define SAA1064_SA3 0x76

//Defines for Segments
const uint8_t SAA1064_SEGM[] = {0xE7,  //0
                                0x84,  //1
                                0xD3,  //2
                                0xD6,  //3
                                0xB4,  //4
                                0x76,  //5
                                0x77,  //6
                                0xC4,  //7
                                0xF7,  //8
                                0xF6,  //9
                                0xF5,  //A
                                0x37,  //B
                                0x13,  //C
                                0x97,  //D
                                0x73,  //E
                                0x71
                               }; //F

/** Create an SAA1064 object connected to the specified I2C bus and deviceAddress
*/
class SAA1064
{
public:

    /** Create a SAA1064 LED displaydriver object using a specified I2C bus and slaveaddress
     *
     * @param sda Pin
     * @param scl Pin
     * @param char deviceAddress the address of the SAA1064
    */
    SAA1064( PinName sda = D14, PinName scl = D15, uint8_t deviceAddress = SAA1064_SA0 );

    SAA1064( I2C* i2c, uint8_t deviceAddress = SAA1064_SA0 );

    /** Write digits
    *
    * @param digit1  LED segment pattern for digit1 (MSB)
    * @param digit2  LED segment pattern for digit2
    * @param digit3  LED segment pattern for digit3
    * @param digit4  LED segment pattern for digit4 (LSB)
    */
    void write(uint8_t digit1, uint8_t digit2, uint8_t digit3, uint8_t digit4);

    /** Write Integer
    *
    * @param value     integer value to display, valid range -999...9999
    */
    void writeInt( int value );

protected:
    void init( void );

    I2C *i2c;                    //I2C bus reference
    uint8_t slaveAddress;        //I2C Slave address of device
    uint8_t data[6];
};

#endif