/** Mikrophone Sensor
 */
#include "mbed.h"

// Mikrophone
AnalogIn mikrophone( A3 );
// Zeitfenster wo Mikrophone ausgewertert wird
int sampleWindow = 1;
DigitalOut led( D10 );

int main()
{
    while(1) 
    {
        // Initialisierung: clock() liefert Zeit seit Einschalten oder Reset des Boards
        int startSec = clock() / CLOCKS_PER_SEC;
        float max = 0.0f;
        
        // Zeitfenster um groessten Wert zu finden
        while  ( (clock() / CLOCKS_PER_SEC) - startSec < sampleWindow )
        {
            float m = mikrophone.read();
            if  ( m > max )
                max = m;
        }
        
        // Auswertung
        printf( "Maximaler Wert %f\n", max );
        if  ( max > 0.4f )
            led = 1;
        else
            led = 0;
    }
}  