/** HTTP (RPC) Server mit UI
*/
#include "mbed.h"
#include "EthernetInterface.h"
#include "mbed_rpc.h"
#include "RPCCommand.h"
#include "HTTPServer.h"
#include "Formatter.h"
#include "RequestHandler.h"
#include "RPCType.h"

#define SERVER_PORT 80

HTTPServer create_simple_server()
{    
    HTTPServer srv;
    srv.add_request_handler("DELETE", new DeleteRequestHandler());
    srv.add_request_handler("GET", new GetRequestHandler());
    srv.add_request_handler("PUT", new PutRequestHandler());
    return srv;
}

HTTPServer create_interactive_server()
{
    HTTPServer srv(new InteractiveHTMLFormatter());
    srv.add_request_handler("GET", new ComplexRequestHandler());
    return srv;
}

int main(void)
{
    RPCType::instance().register_types();    

    EthernetInterface eth;
    if(eth.init())
    {
        printf("Error while initializing the ethernet interface.\n");
        return -1;
    }
    if(eth.connect())
    {
        printf("Error while starting the ethernet interface.\n");
        return -1;
    }
    
    printf("IP Address is %s\n", eth.getIPAddress());
    
    HTTPServer srv = create_interactive_server();

    if(!srv.init(SERVER_PORT))
    {
        eth.disconnect();
        return -1;
    }

    srv.run();

    return 0;
}

