/** 6.5 Wenn sich jemand nähert, Licht (D10) einschalten und
    Akustisches Signal. Alarm ein-/ausschaltbar mittels Tastern. Wenn Alarm scharf ist, leuchtet LED 2
*/
#include "mbed.h"

// Buttons fuer Ein-/Ausschalten
DigitalIn b1( A1 );
DigitalIn b2( A2 );

// Sensor
DigitalIn pirSensor( A5 );

// LED UI
DigitalOut led1( D10 );
DigitalOut led2( D13 );

// Summer (Buzzer)
PwmOut speaker( D7 );

int on = 0;     // On/Off Merker

int main()
{
    while (true)
     {
        // On / Off Buttons
        if  ( b1 == 0 )
            on = 1;
        if  ( b2 == 0 )
            on = 0;
        
        // Alarm scharf?    
        if  ( on )
        {
            led2 = 1;
            // und Bewegungsmelder gibt an
            if  ( pirSensor ) 
            {
                led1 = 1;
                // Polizei Sirene
                speaker.period( 1.0 / 969.0 );      // 969 = Tonfrequenz in Hz
                speaker = 0.5f;
                wait( 0.5f );
                speaker.period( 1.0 / 800.0 );
                wait( 0.5f );
            }
            else
            {
                speaker = 0.0f;
                led1 = 0;
            }
        }
        // Alarm abgeschaltet
        else
        {
            speaker = 0.0f;
            led1 = 0;
            led2 = 0;
        } 

        wait( 0.2 );    // ohne wait laesst sich das Board nicht neu programmieren!              
    }
}