/** 6.4 Wenn sich jemand nähert, Lauflicht einschalten und Akustisches Signal
*/
#include "mbed.h"

DigitalOut led1( D10 );
DigitalOut led2( D11 );
DigitalOut led3( D12 );
DigitalOut led4( D13 );
PwmOut     buzzer( D7 );           // Buzzer

DigitalIn   pirSensor( A5 );        // Bewegungsmelder schaltet auf 1

int main()
{
    while (true) 
    {
        // hat sich etwas bewegt?
        if  ( pirSensor  ) 
        {
            // 10x Lauflicht durchlaufen
            for ( int t = 0; t < 10; t++ ) 
            {
                // Buzzer bleibt eingeschaltet werden die LED ON sind 
                buzzer.period( 1.0/900.0) ;     // 900hz period
                buzzer = 0.9;                   // 90% duty cycle - max volume 
                for ( int i = 0; i < 5; i++ ) 
                {
                    switch  ( i ) 
                    {
                        case   0:
                            led1 = led2 = led3 = led4 = 0;
                            break;
                        case   1:
                            led1 = 1;
                            break;
                        case   2:
                            led1 = 0;
                            led2 = 1;
                            break;
                        case 3:
                            led2 = 0;
                            led3 = 1;
                            break;
                        case 4:
                            led3 = 0;
                            led4 = 1;
                            break;
                    }
                    // wait bis naechstes LED aktiviert wird
                    wait( 0.2 );
                }
                // Ruhe und alle LED off
                buzzer = 0;
                led4 = 0;
                wait ( 0.5 );
            }
        } else
        {
            led1 = led2 = led3 = led4 = 0;
            buzzer = 0;
        }

        wait( 0.2 );    // ohne wait laesst sich das Board nicht neu programmieren!
    }
}