/** Plotly Cloud Dienst mit Sensorwerten 
    https://plot.ly/~mc-b/11
*/
#include "mbed.h"
#include "EthernetInterface.h"
#include "plotly.h"

Serial pc(USBTX,USBRX);
EthernetInterface eth;
// Sensoren (Poti, Light, Hall)
AnalogIn sensors[] = { A0, A1, A2 };

// plotly account details
const int numberOfTraces = 3;
const char PlotlyUsername[] =  "mc-b";
const char PlotlyAPIToken[] = "ggngm3tplt";
const char *PlotlyStreamingTokens[numberOfTraces] = {"9vdxtza25l","0pfcxy8fp3", "mpyq3oowhe"}; // or {"YourStreamToken"} for a single line. Must match numberOfTraces
const char PlotlyFileName[] = "Mbed Test Chart";

plotly graph = plotly(PlotlyUsername,PlotlyAPIToken, PlotlyStreamingTokens, PlotlyFileName, numberOfTraces);

void plotSetup()
{
    graph.log_level = 1; // turn on status output
    graph.maxpoints = 72;
    if (graph.init()) 
        graph.openStreams();
}

// Generate some simple sample data points
void plotGenerateDataPoint()
{
    static float counter = 0;
    
    // generate a series of sine waves with slightly different frequencies.
    for (int i = 0; i < numberOfTraces; i++) 
      graph.plot(counter, sensors[i].read(), i); 
    
    counter+=0.2f;
}

/** Hauptprogramm */
int main()
{
    pc.printf("Connecting network...\n");
    eth.init();
    eth.connect();

    char *ipAddress = eth.getIPAddress();
    if (ipAddress && (strlen(ipAddress) > 4)) 
    {
        pc.printf("IP Address is %s\n",eth.getIPAddress());
        pc.printf("Initalise plot..\n");

        plotSetup();

        pc.printf("Generating data, press any key to abort.\n");
        while ( !pc.readable() ) 
        {
            plotGenerateDataPoint();
            wait(2.0);
        }
        graph.closeStreams();

    } 
    else
        pc.printf("No IP Address\n");

    eth.disconnect();
    pc.printf("Done\n");
    return  ( 0 );
}