/** KL64Z Fitness Tracker
 *  Sehr, sehr einfacher Fitness Tracker unter Zuhilfename eines 3 Lagen Sensors
 */
#include "mbed.h"
#include "MMA8451Q.h"
#include "SLCD.h"

#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#elif defined (TARGET_K20D50M)
  PinName const SDA = PTB1;
  PinName const SCL = PTB0;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)

// Display
SLCD lcd;
// Anzahl Schritte
long step = 0;
// letzte Z Lage
float last;
// Schwellenwerte
float min = -0.2;
float max = 0.2;


int main(void)
{
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    lcd.clear();

    printf("MMA8451 ID: %d\n", acc.getWhoAmI());

    while (true) 
    {
        float x, y, z;
        x = acc.getAccX();
        y = acc.getAccY();
        z = acc.getAccZ();
        wait( 0.2f );
        printf( "X: %1.2f, Y: %1.2f, Z: %1.2f, step: %d\n", x, y, z, step );
        
        if  ( z > max && last < min )
            step++;
        
        lcd.Home();
        lcd.printf( "%4d", step );
        last = z;
    }
}
