/** 
 * PwmOut Resourcen Abhandlung - Klassen Definition
 */
 
#ifndef PWMOUT_RESOURCE_H
#define PWMOUT_RESOURCE_H
 
#include "nsdl_support.h"

class PwmOutResource 
{
public:
    /** Default Konstruktor 
     *  @param pin Pin fuer PwmOut
     *  @param id Path zur Resource
     *  @param name Name welcher angezeigt werden soll 
     */
    PwmOutResource( PinName pin, char *name, char *id ); 
    
    /** Erstellt die Resource 
     *  @param sn_nsdl_resource_info_s CoAP struct
     *  @return 0 wenn ohne Fehler
     */
    int create( sn_nsdl_resource_info_s *resource_ptr );
    
    /** Callback wenn die Resource gelesen oder geaendert werden soll
     *  @param sn_coap_hdr_s
     *  @param sn_nsdl_addr_s
     *  @param sn_proto_info_s
     *  @return 0 wenn ohne Fehler
     */
    static uint8_t callback( sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto );
    
private:
    /** naechste verkettete Resource, (PwmOutResource) * 0 = Ende der Kette */
    PwmOutResource *next;
    /** Effektive Resource */
    PwmOut *resource;
    /** Id / Path */
    char *id;
    /** Name */
    char *name;
};
 
#endif /* PWMOUT_RESOURCE_H */
