/**
 * Implementierung PwmOut Resource
 */
 
#include "PwmOutResource.h" 

/** Erste verkettete Resource */
PwmOutResource * firstPwmOutResource;
 
/** Default Konstruktor 
 *  @param pin Pin fuer PwmOut 
 */ 
PwmOutResource::PwmOutResource( PinName pin, char *name, char *id ) 
{
    resource = new PwmOut( pin ); 
    this->id = id;
    this->name = name;
    
    // neu verketten - letztes hinzugefuegstes Element = first.
    if  ( firstPwmOutResource != (PwmOutResource *) 0 )
        this->next = firstPwmOutResource;
    firstPwmOutResource = this;
}
 
/** Erstellt die Resource 
 *  @param sn_nsdl_resource_info_s CoAP struct
 *  @return 0 wenn ohne Fehler
 */ 
int PwmOutResource::create( sn_nsdl_resource_info_s *resource_ptr )
{
    nsdl_create_dynamic_resource(resource_ptr, strlen(id), (uint8_t*) id, strlen(name), (uint8_t*) name, 0, &PwmOutResource::callback, (SN_GRS_GET_ALLOWED | SN_GRS_PUT_ALLOWED));
    return  ( 0 );
}

/** Callback wenn die Resource gelesen oder geaendert werden soll
 *  @param sn_coap_hdr_s
 *  @param sn_nsdl_addr_s
 *  @param sn_proto_info_s
 *  @return 0 wenn ohne Fehler
 */
uint8_t PwmOutResource::callback( sn_coap_hdr_s *received_coap_ptr, sn_nsdl_addr_s *address, sn_proto_info_s * proto )
{
    sn_coap_hdr_s *coap_res_ptr = 0;
    char buf[8];
    char path[8];
    PwmOutResource* current;
 
    // Path wegkopieren mit \0
    strncpy( path, (const char*) received_coap_ptr->uri_path_ptr, received_coap_ptr->uri_path_len );
    printf("light callback %s\r\n", path );
    
    // Resource laut path suchen
    for ( current = firstPwmOutResource; current != (PwmOutResource *) 0; current = current->next )
        if  ( strcmp( path, current->id ) == 0 )
            break;
    // nichts gefunden - keine weitere Abhandlung
    if  ( current == (PwmOutResource*) 0 )
        return  ( 1 );
 
    // CoAP GET
    if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_GET)
    {
        coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CONTENT);

        sprintf( buf, "%d",  (int) (current->resource->read() * 100) );
        coap_res_ptr->payload_len = strlen( buf );
        coap_res_ptr->payload_ptr = (uint8_t*) buf;
        sn_nsdl_send_coap_message(address, coap_res_ptr);
    }
    // CoAP PUT
    else if(received_coap_ptr->msg_code == COAP_MSG_CODE_REQUEST_PUT)
    {
        memcpy(buf, (char *)received_coap_ptr->payload_ptr, received_coap_ptr->payload_len);
        buf[received_coap_ptr->payload_len] = '\0';
        current->resource->write( atof( buf ) / 100 );
 
        coap_res_ptr = sn_coap_build_response(received_coap_ptr, COAP_MSG_CODE_RESPONSE_CHANGED);
        sn_nsdl_send_coap_message(address, coap_res_ptr);
    }
 
    sn_coap_parser_release_allocated_coap_msg_mem(coap_res_ptr);    
    return  ( 0 );
}
