/**  CoAP Device Server Client
    Zeile 29: Node Name aendern und auf der Gegenseite leshan Server Verwenden.
*/ 
#include "mbed.h"
#include "EthernetInterface.h"
#include "nsdl_support.h"
#include "dbg.h"

// Include various resources
#include "PwmOutResource.h"

PwmOutResource led1( D11, "led1", "10/0/0" );
PwmOutResource led2( D12, "led2", "10/0/1" );
PwmOutResource led3( D13, "led3", "10/0/2" );

char *staticResources[4] [3] = { { "3/0/0", "Manufacturer", "mc-b" },
                                 { "3/0/1", "Model Number", "CoAP mbed device" },
                                 { "5/0/3", "Firmware", "1" },
                                 { "6/0/0", "GPS Informationen", "67,21" },
                               };

Serial pc(USBTX, USBRX); // tx, rx

// ****************************************************************************
// Server configuration
/* Change this IP address to that of your NanoService Platform installation */
static const char* NSP_ADDRESS = "leshan.eclipse.org"; /* Eclipse leshan Server */ 
static const int NSP_PORT = 5683;
char endpoint_name[64] = "mbed-k64f-";   // wird ergaenzt um MAC Adresse
uint8_t ep_type[] = {"mbed_device"};
uint8_t lifetime_ptr[] = {"1200"};

// ****************************************************************************
// Ethernet initialization

EthernetInterface eth;

static void ethernet_init()
{
    //char mbed_uid[33]; // for creating unique name for the board

    /* Initialize network */
    eth.init();
    
    if(eth.connect(30000) == 0)
        pc.printf("Connect OK\n\r");

    // Board Name + MAC = EndPoint Name
    strcat( endpoint_name, eth.getMACAddress() );

    printf( "IP:%s", eth.getIPAddress() );
    printf( "NetMask is %s\r\n", eth.getNetworkMask() );
    printf( "Gateway Address is %s\r\n", eth.getGateway() );
    printf( "MAC Address is %s\r\n", eth.getMACAddress() );    
    printf( "Endpoint is %s\r\n", endpoint_name );
    
    NSDL_DEBUG("IP Address:%s ", eth.getIPAddress() );
}

// ****************************************************************************
// NSP initialization

UDPSocket server;
Endpoint nsp;

static void nsp_init()
{
    server.init();
    server.bind(NSP_PORT);

    nsp.set_address(NSP_ADDRESS, NSP_PORT);
    
    NSDL_DEBUG("name: %s", endpoint_name);
    NSDL_DEBUG("NSP=%s - port %d\n", NSP_ADDRESS, NSP_PORT);

    printf("EP name:%s\n", endpoint_name);
}

// ****************************************************************************
// Resource creation

static int create_resources()
{
    sn_nsdl_resource_info_s *resource_ptr = NULL;
    sn_nsdl_ep_parameters_s *endpoint_ptr = NULL;
    
    NSDL_DEBUG("Creating resources");

    /* Create resources */
    resource_ptr = (sn_nsdl_resource_info_s*)nsdl_alloc(sizeof(sn_nsdl_resource_info_s));
    if(!resource_ptr)
        return 0;
    memset(resource_ptr, 0, sizeof(sn_nsdl_resource_info_s));

    resource_ptr->resource_parameters_ptr = (sn_nsdl_resource_parameters_s*)nsdl_alloc(sizeof(sn_nsdl_resource_parameters_s));
    if(!resource_ptr->resource_parameters_ptr)
    {
        nsdl_free(resource_ptr);
        return 0;
    }
    memset(resource_ptr->resource_parameters_ptr, 0, sizeof(sn_nsdl_resource_parameters_s));

    // Static resources
    nsdl_create_static_resource( resource_ptr, strlen(staticResources[0] [0]), (uint8_t*) staticResources[0] [0], 0, 0, 
                                               (uint8_t*) staticResources[0] [2], strlen(staticResources[0] [2]) );
    nsdl_create_static_resource( resource_ptr, strlen(staticResources[1] [0]), (uint8_t*) staticResources[1] [0], 0, 0, 
                                               (uint8_t*) staticResources[1] [2], strlen(staticResources[1] [2]) );
                                               
    nsdl_create_static_resource( resource_ptr, strlen(staticResources[2] [0]), (uint8_t*) staticResources[2] [0], 0, 0, 
                                               (uint8_t*) staticResources[2] [2], strlen(staticResources[2] [2]) );
    nsdl_create_static_resource( resource_ptr, strlen(staticResources[3] [0]), (uint8_t*) staticResources[3] [0], 0, 0, 
                                               (uint8_t*) staticResources[3] [2], strlen(staticResources[3] [2]) );                                               

    // Dynamic resources
    led1.create( resource_ptr );
    led2.create( resource_ptr );
    led3.create( resource_ptr );        

        /* Register with NSP */
    endpoint_ptr = nsdl_init_register_endpoint(endpoint_ptr, (uint8_t*)endpoint_name, ep_type, lifetime_ptr);
    if(sn_nsdl_register_endpoint(endpoint_ptr) != 0)
        pc.printf("NSP registering failed\r\n");
    else
        pc.printf("NSP registering OK\r\n");
    nsdl_clean_register_endpoint(&endpoint_ptr);

    nsdl_free(resource_ptr->resource_parameters_ptr);
    nsdl_free(resource_ptr);
    return 1;
}

// ****************************************************************************
// Program entry point

int main()
{
    printf("mbed NanoService demo");
    NSDL_DEBUG("mbed NanoService Example App 0.1\n");
    
    // Initialize Ethernet interface first
    ethernet_init();
    
    // Initialize NSP node
    nsp_init();
    
    // Initialize NSDL stack
    nsdl_init();
    
    // Create NSDL resources
    create_resources();
    
    // Run the NSDL event loop (never returns)
    nsdl_event_loop();
}
