/** 10.2 Kombiniert die Übung 9.3 Licht zeitgesteuert Ein- und Ausschalten mit dem Sunset Sunrise Dienst, 
    damit bei Sonnenuntergang das Licht ein und bei Sonnenaufgang das Licht ausgeschaltet wird
 */
#include "mbed.h"
#include "HTTPClient.h"
#include "HTTPText.h"
#include "EthernetInterface.h"
#include "MbedJSONValue.h"
#include <string>
#include "NTPClient.h"

EthernetInterface eth;
NTPClient ntp;
// HTTPClient Hilfsklasse
HTTPClient http;
// I/O Buffer
char message[6000];

DigitalOut myled(LED1);
// Licht
DigitalOut led( D10 );

int main()
{
    printf("\tSunriseSunset Cloud Dienst - Licht ein-/ausschalten\n");
    eth.init();
    eth.connect();
    
    // Zeit vom Time Server holen
    printf("Trying to update time...\r\n");
    if (ntp.setTime("1.pool.ntp.org") == 0) 
    {
        printf("Set time successfully\r\n");
        time_t ctTime;
        ctTime = time(NULL);
        printf("Time is set to (UTC): %s\r\n", ctime(&ctTime));
    } 
    else
        printf("Error\r\n");

    while(1) 
    {
        myled = 1;
        int ret = http.get("http://api.sunrise-sunset.org/json?lat=47.3686498&lng=8.5391825", message, sizeof(message));
        if ( !ret ) 
        {
            MbedJSONValue parser;
            // HTTP GET (JSON) parsen  
            parse( parser, message );  
            
            std::string sunrise;
            std::string sunset;            
            
            sunrise = parser["results"]["sunrise"].get<std::string>();
            sunset  = parser["results"]["sunset"] .get<std::string>(); 
            
            // Umwandlung nach int. Damit die Zeiten besser verglichen werden können.
            int rh, rm, rs, sh, sm, ss;
            sscanf( sunrise.c_str(), "%d:%d:%d AM", &rh, &rm, &rs );
            sscanf( sunset .c_str(), "%d:%d:%d PM", &sh, &sm, &ss );
            
            printf( "Sonnenauf- %02d.%02d.%02d und untergang %02d.%02d.%02d\n", rh+2, rm, rs, sh+2+12, sm, ss );
            
            // Aktuelle Zeit
            time_t seconds = time(NULL);
            struct tm * now = localtime( & seconds );
            printf( "%d.%d.%d %2d:%2d:%2d\n", now->tm_mday, now->tm_mon + 1, now->tm_year + 1900, now->tm_hour, now->tm_min, now->tm_sec );             
            
            // Einfache Variante - nur Stunden abfragen
            if  ( now->tm_hour < rh || now->tm_hour > (sh+12) )
                led = 1;          
            else
                led = 0;
        }
        else
            printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
        
        myled = 0;

        wait(10);
    }
    //eth.disconnect();
}
