/** 10.1 Kombiniert die Übung 6.4 Wenn sich jemand nähert, Lauflicht einschalten mit dem Yahoo Weather Dienst, dass bei Unterwarnungen das Lauflicht eingeschaltet wird.
 */
#include "mbed.h"
#include "HTTPClient.h"
#include "HTTPText.h"
#include "EthernetInterface.h"
#include "spdomparser.hpp"
#include "spxmlnode.hpp"
#include "spxmlhandle.hpp"

EthernetInterface eth;
// HTTPClient Hilfsklasse
HTTPClient http;
// I/O Buffer
char message[6000];

DigitalOut myled(LED1);
// Lauflicht
DigitalOut led1( D10 );
DigitalOut led2( D11 );
DigitalOut led3( D12 );
DigitalOut led4( D13 );
PwmOut     buzzer( D7 );           // Buzzer

/** Alarm: Lauflicht und Summer einschalten */
void alarm()
{
    // 10x Lauflicht durchlaufen
    for ( int t = 0; t < 10; t++ ) 
    {
        // Buzzer bleibt eingeschaltet werden die LED ON sind 
        buzzer.period( 1.0 / 900.0) ;   // 900hz period
        buzzer = 0.5;                   // 50% duty cycle - max volume 
        for ( int i = 0; i < 5; i++ ) 
        {
            switch  ( i ) 
            {
                case   0:
                    led1 = led2 = led3 = led4 = 0;
                    break;
                case   1:
                    led1 = 1;
                    break;
                case   2:
                    led1 = 0;
                    led2 = 1;
                    break;
                case 3:
                    led2 = 0;
                    led3 = 1;
                    break;
                case 4:
                    led3 = 0;
                    led4 = 1;
                    break;
            }
            // wait bis naechstes LED aktiviert wird
            wait( 0.2 );
        }
        // Ruhe und alle LED off
        buzzer = 0;
        led4 = 0;
        wait ( 0.5 );
    }
}

int main()
{
    printf("\tYahoo Weather\n");
    eth.init();
    eth.connect();

    while(1) 
    {
        myled = 1;
        // Yahoo Weather fuer Zuerich
        int ret = http.get("http://weather.yahooapis.com/forecastrss?w=784794&u=c", message, sizeof(message));
        if ( !ret ) 
        {
            // XML Parser
            SP_XmlDomParser parser;
            // char[] bzw. XML parsen
            parser.append( message, strlen( message ) );
            SP_XmlHandle rootHandle( parser.getDocument()->getRootElement() );
            SP_XmlElementNode * node = rootHandle.getChild( "channel" ).toElement();

            SP_XmlHandle handle(node);
            SP_XmlElementNode * wind = handle.getChild("yweather:wind").toElement();
            // Windgeschwindigkeit
            printf( "Windgeschwindigkeit %s\n", wind->getAttrValue("speed") );
            float speed;
            sscanf( wind->getAttrValue("speed"), "%f", &speed );
            // wenn Wind staerker als 60 Kmh Alarm ausloesen.
            if  ( speed > 60.0f )
                alarm();
        } 
        else
            printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());

        myled = 0;

        wait(10);
    }
    //eth.disconnect();
}
